/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.Serializable;
import org.dcache.auth.GroupPrincipal;

public class GidPrincipal
implements GroupPrincipal,
Serializable {
    static final long serialVersionUID = 7812225739755920892L;
    private long _gid;
    private boolean _isPrimaryGroup;

    public GidPrincipal(long gid, boolean isPrimary) {
        if (gid < 0L) {
            throw new IllegalArgumentException("GID must be non-negative");
        }
        this._gid = gid;
        this._isPrimaryGroup = isPrimary;
    }

    public GidPrincipal(String gid, boolean isPrimary) {
        this(Long.parseLong(gid), isPrimary);
    }

    @Override
    public boolean isPrimaryGroup() {
        return this._isPrimaryGroup;
    }

    public long getGid() {
        return this._gid;
    }

    @Override
    public String getName() {
        return String.valueOf(this._gid);
    }

    @Override
    public String toString() {
        if (this._isPrimaryGroup) {
            return this.getClass().getSimpleName() + "[" + this.getName() + ",primary]";
        }
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GidPrincipal)) {
            return false;
        }
        GidPrincipal otherGid = (GidPrincipal)other;
        return otherGid.getGid() == this.getGid() && otherGid.isPrimaryGroup() == this.isPrimaryGroup();
    }

    @Override
    public int hashCode() {
        return (int)this._gid + (this._isPrimaryGroup ? 1 : 0);
    }
}

