/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.IOHimeraFsException;
import org.dcache.chimera.InodeId;
import org.dcache.chimera.JdbcFs;
import org.dcache.chimera.NotDirChimeraException;
import org.dcache.chimera.UnixPermission;
import org.dcache.chimera.posix.Stat;

public class FsInode {
    private static final int NIBBLES_IN_32_BIT_INTEGER = 8;
    private static final int RADIX_HEXADECIMAL = 16;
    private static final int ID_LENGTH_PNFS_ID = 24;
    protected final String _id;
    private final FsInodeType _type;
    protected final FileSystemProvider _fs;
    private final int _level;
    private Stat _stat;
    private FsInode _parent;
    private boolean _ioEnabled;
    private boolean _ioFlagUpToDate;

    public FsInode(FileSystemProvider fs, String id, FsInodeType type) {
        this(fs, id, type, 0);
    }

    public FsInode(FileSystemProvider fs, String id) {
        this(fs, id, 0);
    }

    public FsInode(FileSystemProvider fs, String id, int level) {
        this(fs, id, FsInodeType.INODE, level);
    }

    public FsInode(FileSystemProvider fs, String id, FsInodeType type, int level) {
        this._id = id;
        this._fs = fs;
        this._level = level;
        this._type = type;
    }

    public FsInode(FileSystemProvider fs) {
        this(fs, FsInode.generateNewID());
    }

    public long id() {
        long id = this._id.length() == 24 ? this.buildPnfsInodeId() : this.buildDecodedAndXoredInodeId();
        return id;
    }

    private long buildPnfsInodeId() {
        int database = Integer.parseInt(this._id.substring(0, 4), 16);
        long high = Long.parseLong(this._id.substring(8, 16), 16);
        long low = Long.parseLong(this._id.substring(16), 16);
        long counter = low >> 3 | (high & 7L) << 29;
        int reversedDatabase = Integer.reverse(database);
        long id = (long)reversedDatabase ^ counter;
        return id & 0xFFFFFFFFL;
    }

    private long buildDecodedAndXoredInodeId() {
        long inodeId = 0L;
        for (int index = 0; index < this._id.length(); index += 8) {
            int endIndex = index + 8;
            if (endIndex > this._id.length()) {
                endIndex = this._id.length();
            }
            String idFragment = this._id.substring(index, endIndex);
            long uint = Long.parseLong(idFragment, 16);
            inodeId ^= uint;
        }
        return inodeId;
    }

    public static final String generateNewID() {
        return InodeId.newID(0);
    }

    public static final String generateNewID(int fsId) {
        return InodeId.newID(fsId);
    }

    public FsInodeType type() {
        return this._type;
    }

    protected final byte[] byteBase(byte[] opaque) {
        ByteBuffer b = ByteBuffer.allocate(128);
        byte[] fh = InodeId.hexStringToByteArray(this._id);
        b.put((byte)this._fs.getFsId()).put((byte)this._type.getType()).put((byte)fh.length).put(fh);
        b.put((byte)opaque.length);
        b.put(opaque);
        return Arrays.copyOf(b.array(), b.position());
    }

    public byte[] getIdentifier() {
        return this.byteBase(Integer.toString(this._level).getBytes());
    }

    @Deprecated
    public String toFullString() {
        return JdbcFs.toHexString(this.getIdentifier());
    }

    public String toString() {
        return this._id;
    }

    public Stat stat() throws ChimeraFsException {
        this._stat = this._fs.stat(this, this._level);
        return this._stat;
    }

    public Stat statCache() throws ChimeraFsException {
        if (this._stat == null) {
            this._stat = this.stat();
        }
        return this._stat;
    }

    public int write(long pos, byte[] data, int offset, int len) {
        int ret = -1;
        try {
            ret = this._fs.write(this, this._level, pos, data, offset, len);
        }
        catch (ChimeraFsException e) {
            // empty catch block
        }
        return ret;
    }

    public int read(long pos, byte[] data, int offset, int len) {
        int ret = -1;
        try {
            ret = this._fs.read(this, this._level, pos, data, offset, len);
        }
        catch (ChimeraFsException e) {
            // empty catch block
        }
        return ret;
    }

    public FsInode mkdir(String newDir) throws ChimeraFsException {
        return this._fs.mkdir(this, newDir);
    }

    public FsInode mkdir(String name2, int owner, int group, int mode) throws ChimeraFsException {
        return this._fs.mkdir(this, name2, owner, group, mode);
    }

    public FsInode inodeOf(String name2) throws ChimeraFsException {
        return this._fs.inodeOf(this, name2);
    }

    public FsInode create(String name2, int uid, int gid, int mode) throws ChimeraFsException {
        return this._fs.createFile(this, name2, uid, gid, mode);
    }

    public FsInode createLink(String name2, int uid, int gid, int mode, byte[] dest) throws ChimeraFsException {
        if (!this.isDirectory()) {
            throw new NotDirChimeraException(this);
        }
        return this._fs.createLink(this, name2, uid, gid, mode, dest);
    }

    public static FsInode getRoot(FileSystemProvider fs) throws ChimeraFsException {
        return fs.path2inode("/");
    }

    public boolean exists() throws ChimeraFsException {
        boolean rc = false;
        try {
            this._stat = this.statCache();
            rc = true;
        }
        catch (FileNotFoundHimeraFsException fileNotFoundHimeraFsException) {
            // empty catch block
        }
        return rc;
    }

    public boolean isDirectory() {
        boolean rc = false;
        try {
            if (this.exists() && (this._stat.getMode() & 0x4000) == 16384) {
                rc = true;
            }
        }
        catch (ChimeraFsException chimeraFsException) {
            // empty catch block
        }
        return rc;
    }

    public boolean isLink() {
        boolean rc = false;
        try {
            if (this.exists() && new UnixPermission(this._stat.getMode()).isSymLink()) {
                rc = true;
            }
        }
        catch (ChimeraFsException chimeraFsException) {
            // empty catch block
        }
        return rc;
    }

    public byte[] readlink() throws ChimeraFsException {
        if (!this.isLink()) {
            throw new ChimeraFsException("not a link");
        }
        return this._fs.readLink(this);
    }

    public void remove(String name2) throws ChimeraFsException {
        if (!this.isDirectory()) {
            throw new IOHimeraFsException("Not a directory");
        }
        this._fs.remove(this, name2);
    }

    public void setUID(int uid) throws ChimeraFsException {
        this._fs.setFileOwner(this, this._level, uid);
        if (this._stat != null) {
            this._stat.setUid(uid);
        }
    }

    public void setGID(int gid) throws ChimeraFsException {
        this._fs.setFileGroup(this, this._level, gid);
        if (this._stat != null) {
            this._stat.setGid(gid);
        }
    }

    public void setSize(long size) throws ChimeraFsException {
        if (this._level != 0) {
            return;
        }
        this._fs.setFileSize(this, size);
        if (this._stat != null) {
            this._stat.setSize(size);
        }
    }

    public void setMode(int mode) throws ChimeraFsException {
        int file_type = this.statCache().getMode() & 0x3F000;
        this._fs.setFileMode(this, this._level, mode | file_type);
        if (this._stat != null) {
            this._stat.setMode(mode | file_type);
        }
    }

    public void setATime(long atime) throws ChimeraFsException {
        this._fs.setFileATime(this, this._level, atime);
        if (this._stat != null) {
            this._stat.setATime(atime);
        }
    }

    public void setCTime(long ctime) throws ChimeraFsException {
        this._fs.setFileCTime(this, this._level, ctime);
        if (this._stat != null) {
            this._stat.setCTime(ctime);
        }
    }

    public void setMTime(long mtime) throws ChimeraFsException {
        this._fs.setFileMTime(this, this._level, mtime);
        if (this._stat != null) {
            this._stat.setMTime(mtime);
        }
    }

    public int fsId() {
        return this._fs.getFsId();
    }

    public FileSystemProvider getFs() {
        return this._fs;
    }

    public FsInode getParent() {
        if (this._parent == null) {
            try {
                this._parent = this._fs.getParentOf(this);
            }
            catch (ChimeraFsException chimeraFsException) {
                // empty catch block
            }
        }
        return this._parent;
    }

    public void setParent(FsInode parent) {
        this._parent = parent;
    }

    public void setStat(Stat predefinedStat) {
        try {
            this._fs.setInodeAttributes(this, this._level, predefinedStat);
        }
        catch (ChimeraFsException chimeraFsException) {
            // empty catch block
        }
        this.setStatCache(predefinedStat);
    }

    void setStatCache(Stat predefinedStat) {
        this._stat = predefinedStat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FsInode)) {
            return false;
        }
        FsInode otherInode = (FsInode)o;
        return this._level == otherInode._level && this._id.equals(otherInode._id) && this._type.equals((Object)otherInode._type);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getIdentifier());
    }

    boolean isIoEnabled() {
        if (!this._ioFlagUpToDate) {
            try {
                this._ioEnabled = this._fs.isIoEnabled(this);
            }
            catch (ChimeraFsException chimeraFsException) {
                // empty catch block
            }
            this._ioFlagUpToDate = true;
        }
        return this._ioEnabled;
    }

    public int getLevel() {
        return this._level;
    }

    public DirectoryStreamB<HimeraDirectoryEntry> newDirectoryStream() throws ChimeraFsException {
        return this._fs.newDirectoryStream(this);
    }
}

