/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.management.Descriptor;
import javax.management.modelmbean.DescriptorSupport;
import org.glassfish.gmbal.impl.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorUtility {
    public static final Descriptor EMPTY_DESCRIPTOR = DescriptorUtility.makeDescriptor(new HashMap());

    private DescriptorUtility() {
    }

    public static Descriptor makeDescriptor(Map<String, ?> fields) {
        if (fields == null) {
            throw Exceptions.self.nullMap();
        }
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            String name2 = entry.getKey();
            if (name2 == null || name2.equals("")) {
                throw Exceptions.self.badFieldName();
            }
            if (map.containsKey(name2)) {
                throw Exceptions.self.duplicateFieldName(name2);
            }
            map.put(name2, entry.getValue());
        }
        int size = map.size();
        String[] names = map.keySet().toArray(new String[size]);
        Object[] values = map.values().toArray(new Object[size]);
        return new DescriptorSupport(names, values);
    }

    public static Descriptor union(Descriptor ... descriptors) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (Descriptor d : descriptors) {
            String[] names;
            if (d == null) continue;
            for (String n : names = d.getFieldNames()) {
                Object v = d.getFieldValue(n);
                map.put(n, v);
            }
        }
        return DescriptorUtility.makeDescriptor(map);
    }
}

