/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.Reader;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.StandaloneProcessorSelector;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.glassfish.grizzly.asyncqueue.AsyncQueueIO;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.monitoring.MonitoringUtils;
import org.glassfish.grizzly.nio.DirectByteBufferRecord;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorIO;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOAsyncQueueReader;
import org.glassfish.grizzly.nio.transport.TCPNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.transport.TCPNIOBindingHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTemporarySelectorReader;
import org.glassfish.grizzly.nio.transport.TCPNIOTemporarySelectorWriter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportFilter;

public final class TCPNIOTransport
extends NIOTransport
implements AsyncQueueEnabledTransport,
FilterChainEnabledTransport,
TemporarySelectorsEnabledTransport {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOTransport.class);
    private static final int DEFAULT_READ_BUFFER_SIZE = -1;
    private static final int DEFAULT_WRITE_BUFFER_SIZE = -1;
    private static final String DEFAULT_TRANSPORT_NAME = "TCPNIOTransport";
    final Collection<TCPNIOServerConnection> serverConnections;
    final AsyncQueueIO<SocketAddress> asyncQueueIO;
    int linger = -1;
    int serverConnectionBackLog = 4096;
    private boolean isOptimizedForMultiplexing;
    private final Filter defaultTransportFilter;
    final RegisterChannelCompletionHandler selectorRegistrationHandler;
    private final TCPNIOConnectorHandler connectorHandler = new TransportConnectorHandler();
    private final TCPNIOBindingHandler bindingHandler = new TCPNIOBindingHandler(this);

    public TCPNIOTransport() {
        this(DEFAULT_TRANSPORT_NAME);
    }

    TCPNIOTransport(String name2) {
        super(name2);
        this.readBufferSize = -1;
        this.writeBufferSize = -1;
        this.selectorRegistrationHandler = new RegisterChannelCompletionHandler();
        this.asyncQueueIO = AsyncQueueIO.Factory.createImmutable(new TCPNIOAsyncQueueReader(this), new TCPNIOAsyncQueueWriter(this));
        this.attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
        this.defaultTransportFilter = new TCPNIOTransportFilter(this);
        this.serverConnections = new ConcurrentLinkedQueue<TCPNIOServerConnection>();
    }

    @Override
    public TemporarySelectorIO createTemporarySelectorIO() {
        return new TemporarySelectorIO(new TCPNIOTemporarySelectorReader(this), new TCPNIOTemporarySelectorWriter(this));
    }

    @Override
    public void listen() {
        this.listenServerConnections();
    }

    @Override
    protected int getDefaultSelectorRunnersCount() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

    private void listenServerConnections() {
        for (TCPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                this.listenServerConnection(serverConnection);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception occurred when starting server connection: " + serverConnection, e);
            }
        }
    }

    void listenServerConnection(TCPNIOServerConnection serverConnection) throws IOException {
        serverConnection.listen();
    }

    @Override
    public TCPNIOServerConnection bind(int port) throws IOException {
        return this.bind(new InetSocketAddress(port));
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port) throws IOException {
        return this.bind(host, port, this.serverConnectionBackLog);
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port, int backlog) throws IOException {
        return this.bind(new InetSocketAddress(host, port), backlog);
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, this.serverConnectionBackLog);
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        return this.bindingHandler.bind(socketAddress, backlog);
    }

    @Override
    public TCPNIOServerConnection bindToInherited() throws IOException {
        return this.bindingHandler.bindToInherited();
    }

    @Override
    public TCPNIOServerConnection bind(String host, PortRange portRange, int backlog) throws IOException {
        return (TCPNIOServerConnection)this.bindingHandler.bind(host, portRange, backlog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Connection connection) {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (connection != null && this.serverConnections.remove(connection)) {
                GrizzlyFuture<Closeable> future = connection.close();
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                    future.recycle(false);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error unbinding connection: " + connection, e);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            for (Connection connection : this.serverConnections) {
                try {
                    this.unbind(connection);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Exception occurred when closing server connection: " + connection, e);
                }
            }
            this.serverConnections.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public GrizzlyFuture<Connection> connect(String host, int port) {
        return this.connectorHandler.connect(host, port);
    }

    @Override
    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress) {
        return this.connectorHandler.connect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, completionHandler);
    }

    @Override
    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connectorHandler.connect(remoteAddress, localAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, localAddress, completionHandler);
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        SelectableChannel nioChannel = ((NIOConnection)connection).getChannel();
        if (nioChannel != null) {
            try {
                nioChannel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
        }
        if (this.asyncQueueIO != null) {
            AsyncQueueWriter<SocketAddress> writer;
            AsyncQueueReader<SocketAddress> reader = this.asyncQueueIO.getReader();
            if (reader != null) {
                reader.onClose(connection);
            }
            if ((writer = this.asyncQueueIO.getWriter()) != null) {
                writer.onClose(connection);
            }
        }
    }

    TCPNIOConnection obtainNIOConnection(SocketChannel channel) {
        TCPNIOConnection connection = new TCPNIOConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    TCPNIOServerConnection obtainServerNIOConnection(ServerSocketChannel channel) {
        TCPNIOServerConnection connection = new TCPNIOServerConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    void configureChannel(SocketChannel channel) throws IOException {
        Socket socket = channel.socket();
        channel.configureBlocking(false);
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Can not set linger to " + this.linger, e);
        }
        try {
            socket.setKeepAlive(this.isKeepAlive());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Can not set keepAlive to " + this.isKeepAlive(), e);
        }
        try {
            socket.setTcpNoDelay(this.isTcpNoDelay());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Can not set TcpNoDelay to " + this.isTcpNoDelay(), e);
        }
        socket.setReuseAddress(this.isReuseAddress());
    }

    @Override
    public AsyncQueueIO<SocketAddress> getAsyncQueueIO() {
        return this.asyncQueueIO;
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = null;
                this.processorSelector = null;
            }
        }
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getServerConnectionBackLog() {
        return this.serverConnectionBackLog;
    }

    public void setServerConnectionBackLog(int serverConnectionBackLog) {
        this.serverConnectionBackLog = serverConnectionBackLog;
    }

    public boolean isOptimizedForMultiplexing() {
        return this.isOptimizedForMultiplexing;
    }

    public void setOptimizedForMultiplexing(boolean isOptimizedForMultiplexing) {
        this.isOptimizedForMultiplexing = isOptimizedForMultiplexing;
        ((TCPNIOAsyncQueueWriter)this.asyncQueueIO.getWriter()).setAllowDirectWrite(!isOptimizedForMultiplexing);
    }

    @Override
    public Filter getTransportFilter() {
        return this.defaultTransportFilter;
    }

    @Override
    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.temporarySelectorIO;
    }

    @Override
    public void fireIOEvent(IOEvent ioEvent, Connection connection, IOEventProcessingHandler processingHandler) {
        if (ioEvent == IOEvent.SERVER_ACCEPT) {
            try {
                ((TCPNIOServerConnection)connection).onAccept();
            }
            catch (IOException e) {
                TCPNIOTransport.failProcessingHandler(ioEvent, connection, processingHandler, e);
            }
            return;
        }
        if (ioEvent == IOEvent.CLIENT_CONNECTED) {
            try {
                ((TCPNIOConnection)connection).onConnect();
            }
            catch (IOException e) {
                TCPNIOTransport.failProcessingHandler(ioEvent, connection, processingHandler, e);
            }
            return;
        }
        Processor conProcessor = connection.obtainProcessor(ioEvent);
        ProcessorExecutor.execute(Context.create(connection, conProcessor, ioEvent, processingHandler));
    }

    @Override
    public Reader<SocketAddress> getReader(Connection connection) {
        return this.getReader(connection.isBlocking());
    }

    @Override
    public Reader<SocketAddress> getReader(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getReader();
        }
        return this.getAsyncQueueIO().getReader();
    }

    @Override
    public Writer<SocketAddress> getWriter(Connection connection) {
        return this.getWriter(connection.isBlocking());
    }

    @Override
    public Writer<SocketAddress> getWriter(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getWriter();
        }
        return this.getAsyncQueueIO().getWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer read(Connection connection, Buffer buffer) throws IOException {
        boolean isAllocate;
        TCPNIOConnection tcpConnection = (TCPNIOConnection)connection;
        boolean bl = isAllocate = buffer == null;
        if (isAllocate) {
            int read;
            try {
                int receiveBufferSize = connection.getReadBufferSize();
                if (!this.memoryManager.willAllocateDirect(receiveBufferSize)) {
                    DirectByteBufferRecord directByteBufferRecord = DirectByteBufferRecord.allocate(receiveBufferSize);
                    try {
                        ByteBuffer directByteBuffer = directByteBufferRecord.getByteBuffer();
                        read = this.readSimpleByteBuffer(tcpConnection, directByteBuffer);
                        directByteBuffer.flip();
                        buffer = this.memoryManager.allocate(read);
                        buffer.put(directByteBuffer);
                    }
                    finally {
                        directByteBufferRecord.release();
                    }
                } else {
                    buffer = this.memoryManager.allocateAtLeast(receiveBufferSize);
                    read = this.readSimple(tcpConnection, buffer);
                }
                tcpConnection.onRead(buffer, read);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "TCPNIOConnection (" + connection + ") (allocated) read exception", e);
                }
                read = -1;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (allocated) read {1} bytes", new Object[]{connection, read});
            }
            if (read > 0) {
                assert (buffer != null);
                buffer.allowBufferDispose(true);
                buffer.position(read);
            } else {
                if (buffer != null) {
                    buffer.dispose();
                    buffer = null;
                }
                if (read < 0) {
                    tcpConnection.close0(null, false);
                    throw new EOFException();
                }
            }
        } else if (buffer.hasRemaining()) {
            int read;
            int oldPos = buffer.position();
            SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
            try {
                if (buffer.isComposite()) {
                    ByteBufferArray array = buffer.toByteBufferArray();
                    ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
                    int size = array.size();
                    read = (int)socketChannel.read(byteBuffers, 0, size);
                    array.restore();
                    array.recycle();
                } else {
                    read = this.readSimple(tcpConnection, buffer);
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "TCPNIOConnection (" + connection + ") (existing) read exception", e);
                }
                read = -1;
            }
            if (read > 0) {
                buffer.position(oldPos + read);
            }
            tcpConnection.onRead(buffer, read);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (nonallocated) read {1} bytes", new Object[]{connection, read});
            }
            if (read < 0) {
                tcpConnection.close0(null, false);
                throw new EOFException();
            }
        }
        return buffer;
    }

    private int readSimple(TCPNIOConnection tcpConnection, Buffer buffer) throws IOException {
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        int read = socketChannel.read(buffer.toByteBuffer());
        return read;
    }

    private int readSimpleByteBuffer(TCPNIOConnection tcpConnection, ByteBuffer byteBuffer) throws IOException {
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        int read = socketChannel.read(byteBuffer);
        return read;
    }

    public int write(TCPNIOConnection connection, WritableMessage message) throws IOException {
        return this.write(connection, message, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(TCPNIOConnection connection, WritableMessage message, WriteResult currentResult) throws IOException {
        if (message instanceof Buffer) {
            Buffer buffer = (Buffer)message;
            int oldPos = buffer.position();
            try {
                boolean hasWritten;
                int written;
                if (buffer.isComposite()) {
                    BufferArray array = buffer.toBufferArray();
                    written = TCPNIOTransport.writeGathered(connection, array);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (composite) write {1} bytes", new Object[]{connection, written});
                    }
                    array.restore();
                    array.recycle();
                } else {
                    written = TCPNIOTransport.writeSimple(connection, buffer);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (plain) write {1} bytes", new Object[]{connection, written});
                    }
                }
                boolean bl = hasWritten = written >= 0;
                if (hasWritten) {
                    buffer.position(oldPos + written);
                }
                connection.onWrite(buffer, written);
                if (!hasWritten) return written;
                if (currentResult == null) return written;
                currentResult.setMessage(message);
                currentResult.setWrittenSize(currentResult.getWrittenSize() + (long)written);
                currentResult.setDstAddressHolder(connection.peerSocketAddressHolder);
                return written;
            }
            catch (IOException e) {
                connection.close0(null, false);
                throw e;
            }
        } else {
            if (!(message instanceof FileTransfer)) throw new IllegalStateException("Unhandled message type");
            return (int)((FileTransfer)message).writeTo((SocketChannel)connection.getChannel());
        }
    }

    private static int writeSimple(TCPNIOConnection tcpConnection, Buffer buffer) throws IOException {
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        if (!buffer.hasRemaining()) {
            return 0;
        }
        return TCPNIOTransport.flushByteBuffer(socketChannel, buffer.toByteBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeGathered(TCPNIOConnection tcpConnection, BufferArray bufferArray) throws IOException {
        Buffer[] buffers = (Buffer[])bufferArray.getArray();
        int length = bufferArray.size();
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        int written = 0;
        DirectByteBufferRecord record = null;
        ByteBuffer directByteBuffer = null;
        try {
            int i = TCPNIOTransport.findNextAvailBuffer(buffers, -1, length);
            while (i < length) {
                int next;
                block13: {
                    Buffer buffer;
                    block12: {
                        int remaining;
                        int currentBufferRemaining;
                        boolean isAdaptByteBuffer;
                        boolean isFlush;
                        buffer = buffers[i];
                        next = TCPNIOTransport.findNextAvailBuffer(buffers, i, length);
                        boolean bl = isFlush = next == length || buffers[next].isDirect();
                        if (buffer.isDirect()) break block12;
                        if (record == null) {
                            record = DirectByteBufferRecord.allocate(tcpConnection.getWriteBufferSize());
                            directByteBuffer = record.getByteBuffer();
                        }
                        boolean bl2 = isAdaptByteBuffer = (currentBufferRemaining = buffer.remaining()) < directByteBuffer.remaining();
                        if (isAdaptByteBuffer) {
                            directByteBuffer.limit(directByteBuffer.position() + currentBufferRemaining);
                        }
                        buffer.get(directByteBuffer);
                        if (isAdaptByteBuffer) {
                            directByteBuffer.limit(directByteBuffer.capacity());
                        }
                        if (directByteBuffer.hasRemaining() && !isFlush) break block13;
                        directByteBuffer.flip();
                        written += TCPNIOTransport.flushByteBuffer(socketChannel, directByteBuffer);
                        if (remaining > 0) {
                            int shift;
                            for (remaining = directByteBuffer.remaining(); remaining > 0; remaining -= shift) {
                                Buffer revertBuffer = buffers[i];
                                shift = Math.min(remaining, revertBuffer.position() - bufferArray.getInitialPosition(i));
                                revertBuffer.position(revertBuffer.position() - shift);
                                --i;
                            }
                            break;
                        }
                        directByteBuffer.clear();
                        if (!buffer.hasRemaining()) break block13;
                        next = i;
                        break block13;
                    }
                    ByteBuffer byteBuffer = buffer.toByteBuffer();
                    written += socketChannel.write(byteBuffer);
                    if (byteBuffer.hasRemaining()) {
                        break;
                    }
                }
                i = next;
            }
        }
        finally {
            if (record != null) {
                directByteBuffer.clear();
                record.release();
            }
        }
        return written;
    }

    private static int findNextAvailBuffer(Buffer[] buffers, int start, int end) {
        for (int i = start + 1; i < end; ++i) {
            if (!buffers[i].hasRemaining()) continue;
            return i;
        }
        return end;
    }

    static int flushByteBuffer(SocketChannel channel, ByteBuffer byteBuffer) throws IOException {
        return channel.write(byteBuffer);
    }

    private static void failProcessingHandler(IOEvent ioEvent, Connection connection, IOEventProcessingHandler processingHandler, IOException e) {
        if (processingHandler != null) {
            try {
                processingHandler.onError(Context.create(connection, null, ioEvent, processingHandler), e);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    @Override
    protected Object createJmxManagementObject() {
        return MonitoringUtils.loadJmxObject("org.glassfish.grizzly.nio.transport.jmx.TCPNIOTransport", this, TCPNIOTransport.class);
    }

    class TransportConnectorHandler
    extends TCPNIOConnectorHandler {
        public TransportConnectorHandler() {
            super(TCPNIOTransport.this);
        }

        @Override
        public Processor getProcessor() {
            return TCPNIOTransport.this.getProcessor();
        }

        @Override
        public ProcessorSelector getProcessorSelector() {
            return TCPNIOTransport.this.getProcessorSelector();
        }
    }

    class RegisterChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        RegisterChannelCompletionHandler() {
        }

        @Override
        public void completed(RegisterChannelResult result) {
            SelectionKey selectionKey = result.getSelectionKey();
            TCPNIOConnection connection = (TCPNIOConnection)TCPNIOTransport.this.getSelectionKeyHandler().getConnectionForKey(selectionKey);
            if (connection != null) {
                SelectorRunner selectorRunner = result.getSelectorRunner();
                connection.setSelectionKey(selectionKey);
                connection.setSelectorRunner(selectorRunner);
            }
        }
    }
}

