/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.pfl.tf.timer.impl.TimerFactoryImpl;
import org.glassfish.pfl.tf.timer.spi.NamedBase;
import org.glassfish.pfl.tf.timer.spi.TimerEvent;
import org.glassfish.pfl.tf.timer.spi.TimerEventHandler;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;

public abstract class TimerEventControllerBase
extends NamedBase {
    private Set<TimerEventHandler> handlers = new HashSet<TimerEventHandler>();
    private Set<TimerEventHandler> roHandlers = Collections.unmodifiableSet(this.handlers);

    public TimerEventControllerBase(TimerFactory factory, String name2) {
        super(factory, name2);
        TimerFactoryImpl tfi = (TimerFactoryImpl)TimerFactoryImpl.class.cast(factory);
        tfi.saveTimerEventController(this);
    }

    public void register(TimerEventHandler handler) {
        this.handlers.add(handler);
    }

    public void deregister(TimerEventHandler handler) {
        this.handlers.remove(handler);
    }

    public Set<TimerEventHandler> handlers() {
        return this.roHandlers;
    }

    protected void propagate(TimerEvent ev) {
        for (TimerEventHandler handler : this.handlers) {
            handler.notify(ev);
        }
    }
}

