/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.pfl.tf.spi.MethodMonitorRegistry;
import org.glassfish.pfl.tf.timer.spi.ObjectRegistrationManager;
import org.glassfish.pfl.tf.timer.spi.Timer;
import org.glassfish.pfl.tf.timer.spi.TimerEventController;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;
import org.glassfish.pfl.tf.timer.spi.TimerFactoryBuilder;

public class TimerManager<T> {
    private final TimerFactory tf;
    private final TimerEventController controller;
    private volatile T tp;
    private volatile boolean isInitialized = false;
    private final Map<Class<?>, List<Timer>> classToTimers = new HashMap();

    public TimerManager(ObjectRegistrationManager orm, String name2) {
        this.tf = TimerFactoryBuilder.make(orm, name2, name2);
        this.controller = this.tf.makeController(name2);
    }

    public TimerManager(String name2) {
        this(null, name2);
    }

    public void destroy() {
        TimerFactoryBuilder.destroy(this.tf);
    }

    private void checkInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("TimerManager is not initialized");
        }
    }

    public void initialize(T tp) {
        if (this.isInitialized) {
            throw new IllegalStateException("TimerManager is already initialized");
        }
        this.tp = tp;
        this.isInitialized = true;
    }

    public T points() {
        this.checkInitialized();
        return this.tp;
    }

    public TimerFactory factory() {
        return this.tf;
    }

    public TimerEventController controller() {
        return this.controller;
    }

    public synchronized List<Timer> getTimers(Class<?> cls) {
        this.checkInitialized();
        List<Timer> result = this.classToTimers.get(cls);
        if (result == null) {
            result = new ArrayList<Timer>();
            List<String> names = MethodMonitorRegistry.getTimerNames(cls);
            for (String name2 : names) {
                String tname = TimerFactoryBuilder.getTimerName(cls.getSimpleName(), name2);
                Timer timer = this.tf.timers().get(tname);
                result.add(timer);
            }
            this.classToTimers.put(cls, result);
        }
        return result;
    }
}

