/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.spi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.dynamic.codegen.impl.Identifier;
import org.glassfish.pfl.tf.timer.spi.Controllable;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;
import org.glassfish.pfl.tf.timer.spi.TimerFactoryBuilder;
import org.glassfish.pfl.tf.timer.spi.TimerGroup;

public class TimingInfoProcessor {
    private boolean done = false;
    private String pkg;
    private TimerFactory tf;
    private Map<String, List<String>> contents;
    private TimerGroup currentTimerGroup;

    private void checkForValidIdentifier(String name2) {
        if (!Identifier.isValidIdentifier((String)name2)) {
            throw new IllegalArgumentException("name " + name2 + " is not a valid Java identifier");
        }
    }

    private void checkDone() {
        if (this.done) {
            throw new IllegalStateException("past getResult: no other methods may be called");
        }
    }

    public TimingInfoProcessor(String name2, String pkg) {
        this.pkg = pkg;
        this.checkForValidIdentifier(name2);
        if (!Identifier.isValidFullIdentifier((String)pkg)) {
            throw new IllegalArgumentException(pkg + " is not a valid package name");
        }
        this.tf = TimerFactoryBuilder.make(name2, name2);
        this.contents = new LinkedHashMap<String, List<String>>();
        this.currentTimerGroup = null;
    }

    public void addTimer(String name2, String desc) {
        this.checkDone();
        this.checkForValidIdentifier(name2);
        if (!this.tf.timerAlreadyExists(name2)) {
            this.tf.makeTimer(name2, desc);
        }
        this.currentTimerGroup = null;
    }

    public void addTimerGroup(String name2, String desc) {
        this.checkDone();
        this.checkForValidIdentifier(name2);
        this.currentTimerGroup = this.tf.makeTimerGroup(name2, desc);
    }

    private void addContained(String timerName, String timerGroupName) {
        List<String> list = this.contents.get(timerGroupName);
        if (list == null) {
            list = new ArrayList<String>();
            this.contents.put(timerGroupName, list);
        }
        list.add(timerName);
    }

    public void containedIn(String timerName, String timerGroupName) {
        this.addContained(timerName, timerGroupName);
    }

    public void contains(String name2) {
        this.checkDone();
        if (this.currentTimerGroup == null) {
            throw new IllegalStateException("contains must be called after an addTimerGroup call");
        }
        String cname = this.currentTimerGroup.name();
        this.addContained(name2, cname);
    }

    private Controllable getControllable(String name2) {
        Controllable result = this.tf.timers().get(name2);
        if (result == null) {
            result = this.tf.timerGroups().get(name2);
        }
        if (result == null) {
            throw new IllegalArgumentException(name2 + " is not a valid Timer or TimerGroup name");
        }
        return result;
    }

    private void updateTimerFactoryContents() {
        for (String str : this.contents.keySet()) {
            List<String> list = this.contents.get(str);
            TimerGroup tg = this.tf.timerGroups().get(str);
            for (String content : list) {
                tg.add(this.getControllable(content));
            }
        }
    }

    public Pair<String, TimerFactory> getResult() {
        this.checkDone();
        this.done = true;
        this.updateTimerFactoryContents();
        Pair<String, TimerFactory> result = new Pair<String, TimerFactory>(this.pkg, this.tf);
        return result;
    }
}

