/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeMetaData;
import liquibase.change.ChangeParameterMetaData;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeNote;
import liquibase.change.DatabaseChangeProperty;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtils;

public abstract class AbstractChange
implements Change {
    private ResourceAccessor resourceAccessor;
    private ChangeSet changeSet;

    @Override
    public void finishInitialization() throws SetupException {
    }

    @Override
    public ChangeMetaData createChangeMetaData() {
        try {
            DatabaseChange databaseChange = this.getClass().getAnnotation(DatabaseChange.class);
            if (databaseChange == null) {
                throw new UnexpectedLiquibaseException("No @DatabaseChange annotation for " + this.getClass().getName());
            }
            HashSet<ChangeParameterMetaData> params = new HashSet<ChangeParameterMetaData>();
            for (PropertyDescriptor property : Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors()) {
                DatabaseChangeProperty annotation;
                Method readMethod = property.getReadMethod();
                Method writeMethod = property.getWriteMethod();
                if (readMethod == null) {
                    try {
                        readMethod = this.getClass().getMethod("is" + StringUtils.upperCaseFirst(property.getName()), new Class[0]);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (readMethod == null || writeMethod == null || (annotation = readMethod.getAnnotation(DatabaseChangeProperty.class)) != null && !annotation.isChangeProperty()) continue;
                params.add(this.createChangeParameterMetadata(property.getDisplayName()));
            }
            HashMap<String, String> notes = new HashMap<String, String>();
            for (DatabaseChangeNote note : databaseChange.databaseNotes()) {
                notes.put(note.database(), note.notes());
            }
            return new ChangeMetaData(databaseChange.name(), databaseChange.description(), databaseChange.priority(), databaseChange.appliesTo(), notes, params);
        }
        catch (Throwable e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    protected ChangeParameterMetaData createChangeParameterMetadata(String parameterName) {
        try {
            String displayName = parameterName.replaceAll("([A-Z])", " $1");
            displayName = displayName.substring(0, 1).toUpperCase() + displayName.substring(1);
            PropertyDescriptor property = null;
            for (PropertyDescriptor prop : Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors()) {
                if (!prop.getDisplayName().equals(parameterName)) continue;
                property = prop;
                break;
            }
            if (property == null) {
                throw new UnexpectedLiquibaseException("Could not find property " + parameterName);
            }
            Method readMethod = property.getReadMethod();
            if (readMethod == null) {
                readMethod = this.getClass().getMethod("is" + StringUtils.upperCaseFirst(property.getName()), new Class[0]);
            }
            Type type = readMethod.getGenericReturnType();
            DatabaseChangeProperty changePropertyAnnotation = readMethod.getAnnotation(DatabaseChangeProperty.class);
            String mustEqualExisting = this.createMustEqualExistingMetaData(parameterName, changePropertyAnnotation);
            String description = this.createDescriptionMetaData(parameterName, changePropertyAnnotation);
            String example = this.createExampleValueMetaData(parameterName, changePropertyAnnotation);
            String since = this.createSinceMetaData(parameterName, changePropertyAnnotation);
            LiquibaseSerializable.SerializationType serializationType = this.createSerializationTypeMetaData(parameterName, changePropertyAnnotation);
            String[] requiredForDatabase = this.createRequiredDatabasesMetaData(parameterName, changePropertyAnnotation);
            String[] supportsDatabase = this.createSupportedDatabasesMetaData(parameterName, changePropertyAnnotation);
            return new ChangeParameterMetaData(this, parameterName, displayName, description, example, since, type, requiredForDatabase, supportsDatabase, mustEqualExisting, serializationType);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    protected String createSinceMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return StringUtils.trimToNull(changePropertyAnnotation.since());
    }

    protected String createDescriptionMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return StringUtils.trimToNull(changePropertyAnnotation.description());
    }

    protected LiquibaseSerializable.SerializationType createSerializationTypeMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return LiquibaseSerializable.SerializationType.NAMED_FIELD;
        }
        return changePropertyAnnotation.serializationType();
    }

    protected String createMustEqualExistingMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return changePropertyAnnotation.mustEqualExisting();
    }

    protected String createExampleValueMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return StringUtils.trimToNull(changePropertyAnnotation.exampleValue());
    }

    protected String[] createRequiredDatabasesMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return new String[]{"COMPUTE"};
        }
        return changePropertyAnnotation.requiredForDatabase();
    }

    protected String[] createSupportedDatabasesMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return new String[]{"COMPUTE"};
        }
        return changePropertyAnnotation.supportsDatabase();
    }

    @Override
    @DatabaseChangeProperty(isChangeProperty=false)
    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    @Override
    public boolean generateStatementsVolatile(Database database) {
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return false;
        }
        for (SqlStatement statement : statements) {
            if (!SqlGeneratorFactory.getInstance().generateStatementsVolatile(statement, database)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return false;
        }
        for (SqlStatement statement : statements) {
            if (!SqlGeneratorFactory.getInstance().generateRollbackStatementsVolatile(statement, database)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Database database) {
        if (this.generateStatementsVolatile(database)) {
            return true;
        }
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return true;
        }
        for (SqlStatement statement : statements) {
            if (SqlGeneratorFactory.getInstance().supports(statement, database)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Warnings warn(Database database) {
        Warnings warnings = new Warnings();
        if (this.generateStatementsVolatile(database)) {
            return warnings;
        }
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return warnings;
        }
        for (SqlStatement statement : statements) {
            if (SqlGeneratorFactory.getInstance().supports(statement, database)) {
                warnings.addAll(SqlGeneratorFactory.getInstance().warn(statement, database));
                continue;
            }
            if (!statement.skipOnUnsupported()) continue;
            warnings.addWarning(statement.getClass().getName() + " is not supported on " + database.getShortName() + ", but " + ChangeFactory.getInstance().getChangeMetaData(this).getName() + " will still execute");
        }
        return warnings;
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors changeValidationErrors = new ValidationErrors();
        for (ChangeParameterMetaData param : ChangeFactory.getInstance().getChangeMetaData(this).getParameters().values()) {
            if (!param.isRequiredFor(database) || param.getCurrentValue(this) != null) continue;
            changeValidationErrors.addError(param.getParameterName() + " is required for " + ChangeFactory.getInstance().getChangeMetaData(this).getName() + " on " + database.getShortName());
        }
        if (changeValidationErrors.hasErrors()) {
            return changeValidationErrors;
        }
        String unsupportedWarning = ChangeFactory.getInstance().getChangeMetaData(this).getName() + " is not supported on " + database.getShortName();
        if (!this.supports(database)) {
            changeValidationErrors.addError(unsupportedWarning);
        } else {
            boolean sawUnsupportedError = false;
            SqlStatement[] statements = this.generateStatements(database);
            if (statements != null) {
                for (SqlStatement statement : statements) {
                    boolean supported = SqlGeneratorFactory.getInstance().supports(statement, database);
                    if (!supported && !sawUnsupportedError) {
                        if (statement.skipOnUnsupported()) continue;
                        changeValidationErrors.addError(unsupportedWarning);
                        sawUnsupportedError = true;
                        continue;
                    }
                    changeValidationErrors.addAll(SqlGeneratorFactory.getInstance().validate(statement, database));
                }
            }
        }
        return changeValidationErrors;
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws RollbackImpossibleException {
        return this.generateRollbackStatementsFromInverse(database);
    }

    @Override
    public boolean supportsRollback(Database database) {
        return this.createInverses() != null;
    }

    @Override
    public CheckSum generateCheckSum() {
        return CheckSum.compute(new StringChangeLogSerializer().serialize(this, false));
    }

    private SqlStatement[] generateRollbackStatementsFromInverse(Database database) throws RollbackImpossibleException {
        Change[] inverses = this.createInverses();
        if (inverses == null) {
            throw new RollbackImpossibleException("No inverse to " + this.getClass().getName() + " created");
        }
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        try {
            for (Change inverse : inverses) {
                if (!inverse.supports(database)) {
                    throw new RollbackImpossibleException(ChangeFactory.getInstance().getChangeMetaData(inverse).getName() + " is not supported on " + database.getShortName());
                }
                statements.addAll(Arrays.asList(inverse.generateStatements(database)));
            }
        }
        catch (LiquibaseException e) {
            throw new RollbackImpossibleException(e);
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    protected Change[] createInverses() {
        return null;
    }

    @Override
    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects(Database database) {
        if (this.generateStatementsVolatile(database)) {
            return new HashSet<DatabaseObject>();
        }
        HashSet<DatabaseObject> affectedObjects = new HashSet<DatabaseObject>();
        SqlStatement[] statements = this.generateStatements(database);
        if (statements != null) {
            for (SqlStatement statement : statements) {
                affectedObjects.addAll(SqlGeneratorFactory.getInstance().getAffectedDatabaseObjects(statement, database));
            }
        }
        return affectedObjects;
    }

    @Override
    public Set<String> getSerializableFields() {
        return ChangeFactory.getInstance().getChangeMetaData(this).getParameters().keySet();
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        return ChangeFactory.getInstance().getChangeMetaData(this).getParameters().get(field).getCurrentValue(this);
    }

    @Override
    public String getSerializedObjectName() {
        return ChangeFactory.getInstance().getChangeMetaData(this).getName();
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        return ChangeFactory.getInstance().getChangeMetaData(this).getParameters().get(field).getSerializationType();
    }
}

