/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.integration.ant.AntResourceAccessor;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public abstract class BaseLiquibaseTask
extends Task {
    private String changeLogFile;
    private String driver;
    private String url;
    private String username;
    private String password;
    protected Path classpath;
    private boolean promptOnNonLocalDatabase = false;
    private String currentDateTimeFunction;
    private String contexts;
    private String outputFile;
    private String defaultCatalogName;
    private String defaultSchemaName;
    private String databaseClass;
    private String databaseChangeLogTableName;
    private String databaseChangeLogLockTableName;
    private Map<String, Object> changeLogProperties = new HashMap<String, Object>();

    public BaseLiquibaseTask() {
        new LogRedirector(this).redirectLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws BuildException {
        super.execute();
        AntClassLoader loader = this.getProject().createClassLoader(this.classpath);
        loader.setParent(((Object)((Object)this)).getClass().getClassLoader());
        loader.setThreadContextLoader();
        try {
            this.executeWithLiquibaseClassloader();
        }
        finally {
            loader.resetThreadContextLoader();
        }
    }

    protected abstract void executeWithLiquibaseClassloader() throws BuildException;

    public boolean isPromptOnNonLocalDatabase() {
        return this.promptOnNonLocalDatabase;
    }

    public void setPromptOnNonLocalDatabase(boolean promptOnNonLocalDatabase) {
        this.promptOnNonLocalDatabase = promptOnNonLocalDatabase;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver.trim();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url.trim();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username.trim();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.trim();
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile.trim();
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public String getCurrentDateTimeFunction() {
        return this.currentDateTimeFunction;
    }

    public void setCurrentDateTimeFunction(String currentDateTimeFunction) {
        this.currentDateTimeFunction = currentDateTimeFunction.trim();
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile.trim();
    }

    public Writer createOutputWriter() throws IOException {
        if (this.outputFile == null) {
            return null;
        }
        return new FileWriter(new File(this.getOutputFile()));
    }

    public PrintStream createPrintStream() throws IOException {
        if (this.outputFile == null) {
            return null;
        }
        return new PrintStream(new File(this.getOutputFile()));
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public void setDefaultCatalogName(String defaultCatalogName) {
        this.defaultCatalogName = defaultCatalogName;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName.trim();
    }

    public void addConfiguredChangeLogProperty(ChangeLogProperty changeLogProperty) {
        this.changeLogProperties.put(changeLogProperty.getName(), changeLogProperty.getValue());
    }

    protected Liquibase createLiquibase() throws Exception {
        AntResourceAccessor antFO = new AntResourceAccessor(this.getProject(), this.classpath);
        FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor();
        Database database = this.createDatabaseObject(this.getDriver(), this.getUrl(), this.getUsername(), this.getPassword(), this.getDefaultCatalogName(), this.getDefaultSchemaName(), this.getDatabaseClass());
        String changeLogFile = null;
        if (this.getChangeLogFile() != null) {
            changeLogFile = this.getChangeLogFile().trim();
        }
        Liquibase liquibase = new Liquibase(changeLogFile, (ResourceAccessor)new CompositeResourceAccessor(antFO, fsFO), database);
        liquibase.setCurrentDateTimeFunction(this.currentDateTimeFunction);
        for (Map.Entry<String, Object> entry : this.changeLogProperties.entrySet()) {
            liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
        }
        return liquibase;
    }

    protected Database createDatabaseObject(String driverClassName, String databaseUrl, String username, String password, String defaultCatalogName, String defaultSchemaName, String databaseClass) throws Exception {
        Connection connection;
        String[] strings = this.classpath.list();
        final ArrayList<URL> taskClassPath = new ArrayList<URL>();
        for (String string : strings) {
            URL url = new File(string).toURL();
            taskClassPath.add(url);
        }
        URLClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(taskClassPath.toArray(new URL[taskClassPath.size()]), Database.class.getClassLoader());
            }
        });
        if (databaseClass != null) {
            try {
                DatabaseFactory.getInstance().register((Database)Class.forName(databaseClass, true, loader).newInstance());
            }
            catch (ClassCastException e) {
                DatabaseFactory.getInstance().register((Database)Class.forName(databaseClass).newInstance());
            }
        }
        if (driverClassName == null) {
            driverClassName = DatabaseFactory.getInstance().findDefaultDriver(databaseUrl);
        }
        if (driverClassName == null) {
            throw new DatabaseException("driver not specified and no default could be found for " + databaseUrl);
        }
        Driver driver = (Driver)Class.forName(driverClassName, true, loader).newInstance();
        Properties info = new Properties();
        if (username != null) {
            info.put("user", username);
        }
        if (password != null) {
            info.put("password", password);
        }
        if ((connection = driver.connect(databaseUrl, info)) == null) {
            throw new DatabaseException("Connection could not be created to " + databaseUrl + " with driver " + driver.getClass().getName() + ".  Possibly the wrong driver for the given database URL");
        }
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
        database.setDefaultCatalogName(defaultCatalogName);
        database.setDefaultSchemaName(defaultSchemaName);
        if (this.getDatabaseChangeLogTableName() != null) {
            database.setDatabaseChangeLogTableName(this.getDatabaseChangeLogTableName());
        }
        if (this.getDatabaseChangeLogLockTableName() != null) {
            database.setDatabaseChangeLogLockTableName(this.getDatabaseChangeLogLockTableName());
        }
        return database;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String cntx) {
        this.contexts = cntx.trim();
    }

    protected boolean shouldRun() {
        String shouldRunProperty = System.getProperty("liquibase.should.run");
        if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
            this.log("Liquibase did not run because 'liquibase.should.run' system property was set to false");
            return false;
        }
        return true;
    }

    protected void closeDatabase(Liquibase liquibase) {
        if (liquibase != null && liquibase.getDatabase() != null && liquibase.getDatabase().getConnection() != null) {
            try {
                liquibase.getDatabase().close();
            }
            catch (DatabaseException e) {
                this.log("Error closing database: " + e.getMessage());
            }
        }
    }

    public String getDatabaseClass() {
        return this.databaseClass;
    }

    public void setDatabaseClass(String databaseClass) {
        this.databaseClass = databaseClass;
    }

    public String getDatabaseChangeLogTableName() {
        return this.databaseChangeLogTableName;
    }

    public void setDatabaseChangeLogTableName(String tableName) {
        this.databaseChangeLogTableName = tableName;
    }

    public String getDatabaseChangeLogLockTableName() {
        return this.databaseChangeLogLockTableName;
    }

    public void setDatabaseChangeLogLockTableName(String tableName) {
        this.databaseChangeLogLockTableName = tableName;
    }

    public String getLogLevel() {
        return LogFactory.getLogger().getLogLevel().name();
    }

    public void setLogLevel(String level) {
        LogFactory.getLogger().setLogLevel(level);
    }

    public static class ChangeLogProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name2) {
            this.name = name2;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    protected static class LogRedirector {
        private final Task task;

        protected LogRedirector(Task task) {
            this.task = task;
        }

        protected void redirectLogger() {
            this.registerHandler(this.createHandler());
        }

        protected void registerHandler(Handler theHandler) {
            Logger logger = LogFactory.getLogger();
        }

        protected Handler createHandler() {
            return new Handler(){

                @Override
                public void publish(LogRecord logRecord) {
                    LogRedirector.this.task.log(logRecord.getMessage(), this.mapLevelToAntLevel(logRecord.getLevel()));
                }

                @Override
                public void close() throws SecurityException {
                }

                @Override
                public void flush() {
                }

                protected int mapLevelToAntLevel(Level level) {
                    if (Level.ALL == level) {
                        return 2;
                    }
                    if (Level.SEVERE == level) {
                        return 0;
                    }
                    if (Level.WARNING == level) {
                        return 1;
                    }
                    if (Level.INFO == level) {
                        return 2;
                    }
                    return 3;
                }
            };
        }
    }
}

