/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.IOException;
import java.io.InputStream;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.util.file.FilenameUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class LiquibaseEntityResolver
implements EntityResolver2 {
    private static final String SEARCH_PACKAGE = "liquibase/parser/core/xml/";
    private ResourceAccessor resourceAccessor;
    private String basePath;
    private Logger log = LogFactory.getLogger();

    public void useResoureAccessor(ResourceAccessor resourceAccessor, String basePath) {
        this.resourceAccessor = resourceAccessor;
        this.basePath = basePath;
    }

    @Override
    public InputSource resolveEntity(String name2, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        InputSource resolved = null;
        if (systemId != null && systemId.toLowerCase().endsWith(".xsd")) {
            resolved = this.tryResolveLiquibaseSchema(systemId, publicId);
        }
        if (resolved == null && this.resourceAccessor != null && this.basePath != null && systemId != null) {
            resolved = this.tryResolveFromResourceAccessor(systemId);
        }
        return resolved;
    }

    private InputSource tryResolveLiquibaseSchema(String systemId, String publicId) {
        int iSlash;
        if (systemId != null && (iSlash = systemId.lastIndexOf(47)) >= 0) {
            String xsdFile = systemId.substring(iSlash + 1);
            try {
                InputStream resourceAsStream = null;
                if (Thread.currentThread().getContextClassLoader() != null) {
                    resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(SEARCH_PACKAGE + xsdFile);
                }
                if (resourceAsStream == null) {
                    resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(SEARCH_PACKAGE + xsdFile);
                }
                if (resourceAsStream == null) {
                    return null;
                }
                InputSource source = new InputSource(resourceAsStream);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private InputSource tryResolveFromResourceAccessor(String systemId) {
        String path = FilenameUtils.concat(this.basePath, systemId);
        try {
            return new InputSource(this.resourceAccessor.getResourceAsStream(path));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public InputSource getExternalSubset(String name2, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.log.warning("Current XML parsers seems to not support EntityResolver2. External entities won't be correctly loaded");
        return this.tryResolveLiquibaseSchema(systemId, publicId);
    }
}

