/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.yaml;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import liquibase.changelog.ChangeSet;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceCurrentValueFunction;
import liquibase.statement.SequenceNextValueFunction;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.GenericProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class YamlChangeLogSerializer
implements ChangeLogSerializer {
    protected Yaml yaml = this.createYaml();

    protected Yaml createYaml() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(new LiquibaseRepresenter(), dumperOptions);
    }

    @Override
    public String[] getValidFileExtensions() {
        return new String[]{"yaml"};
    }

    @Override
    public String serialize(LiquibaseSerializable object, boolean pretty) {
        return this.yaml.dumpAsMap(this.toMap(object));
    }

    protected Map<String, Object> toMap(LiquibaseSerializable object) {
        Comparator<String> comparator = object instanceof ChangeSet ? new ChangeSetComparator() : new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        TreeMap<String, Map<String, Object>> objectMap = new TreeMap<String, Map<String, Object>>(comparator);
        for (String field : object.getSerializableFields()) {
            Map<String, Object> value = object.getSerializableFieldValue(field);
            if (value == null) continue;
            if (value instanceof LiquibaseSerializable) {
                value = this.toMap((LiquibaseSerializable)((Object)value));
            }
            if (value instanceof Collection) {
                ArrayList<Map<String, Object>> valueAsList = new ArrayList<Map<String, Object>>((Collection)((Object)value));
                if (valueAsList.size() == 0) continue;
                for (int i = 0; i < valueAsList.size(); ++i) {
                    if (!(valueAsList.get(i) instanceof LiquibaseSerializable)) continue;
                    valueAsList.set(i, this.toMap((LiquibaseSerializable)valueAsList.get(i)));
                }
                value = valueAsList;
            }
            objectMap.put(field, value);
        }
        HashMap<String, Object> containerMap = new HashMap<String, Object>();
        containerMap.put(object.getSerializedObjectName(), objectMap);
        return containerMap;
    }

    @Override
    public void write(List<ChangeSet> changeSets, OutputStream out) throws IOException {
    }

    @Override
    public void append(ChangeSet changeSet, File changeLogFile) throws IOException {
    }

    private static class ChangeSetComparator
    implements Comparator<String> {
        private static final Map<String, Integer> order = new HashMap<String, Integer>();

        private ChangeSetComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int orderCompare;
            Integer o2Order;
            Integer o1Order = order.get(o1);
            if (o1Order == null) {
                o1Order = 10;
            }
            if ((o2Order = order.get(o2)) == null) {
                o2Order = 10;
            }
            if ((orderCompare = o1Order.compareTo(o2Order)) == 0) {
                return o1.compareTo(o2);
            }
            return orderCompare;
        }

        static {
            order.put("id", 1);
            order.put("author", 2);
            order.put("changes", Integer.MAX_VALUE);
        }
    }

    public static class LiquibaseRepresenter
    extends Representer {
        public LiquibaseRepresenter() {
            this.multiRepresenters.put(DatabaseFunction.class, new AsStringRepresenter());
            this.multiRepresenters.put(SequenceNextValueFunction.class, new AsStringRepresenter());
            this.multiRepresenters.put(SequenceCurrentValueFunction.class, new AsStringRepresenter());
        }

        @Override
        protected Tag getTag(Class<?> clazz, Tag defaultTag) {
            return super.getTag(clazz, defaultTag);
        }

        @Override
        protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
            return super.representJavaBean(properties, javaBean);
        }

        @Override
        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }

        @Override
        public Node represent(Object data) {
            return super.represent(data);
        }

        @Override
        protected Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
            LiquibaseSerializable serialzableType;
            HashSet<Property> returnSet;
            block6: {
                returnSet = new HashSet<Property>();
                serialzableType = null;
                try {
                    if (type.equals(ChangeSet.class)) {
                        serialzableType = new ChangeSet("x", "y", false, false, null, null, null, null);
                        break block6;
                    }
                    if (LiquibaseSerializable.class.isAssignableFrom(type)) {
                        serialzableType = (LiquibaseSerializable)type.newInstance();
                        break block6;
                    }
                    return super.getProperties(type);
                }
                catch (InstantiationException e) {
                    throw new UnexpectedLiquibaseException(e);
                }
                catch (IllegalAccessException e) {
                    throw new UnexpectedLiquibaseException(e);
                }
            }
            for (String property : serialzableType.getSerializableFields()) {
                LiquibaseSerializable.SerializationType fieldType = serialzableType.getSerializableFieldType(property);
                returnSet.add(new LiquibaseProperty(property, String.class, (Type)((Object)String.class)));
            }
            return returnSet;
        }

        private class AsStringRepresenter
        implements Represent {
            private AsStringRepresenter() {
            }

            @Override
            public Node representData(Object data) {
                return LiquibaseRepresenter.this.representScalar(Tag.STR, data.toString());
            }
        }

        private static class LiquibaseProperty
        extends GenericProperty {
            private LiquibaseProperty(String name2, Class<?> aClass, Type aType) {
                super(name2, aClass, aType);
            }

            @Override
            public void set(Object object, Object value) throws Exception {
            }

            @Override
            public Object get(Object object) {
                return ((LiquibaseSerializable)object).getSerializableFieldValue(this.getName());
            }
        }
    }
}

