/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.enums;

import java.util.HashMap;
import java.util.Map;

public enum AccessMask {
    READ_DATA(1, 'r'),
    LIST_DIRECTORY(1, 'l'),
    WRITE_DATA(2, 'w'),
    ADD_FILE(2, 'f'),
    APPEND_DATA(4, 'a'),
    ADD_SUBDIRECTORY(4, 's'),
    READ_NAMED_ATTRS(8, 'n'),
    WRITE_NAMED_ATTRS(16, 'N'),
    EXECUTE(32, 'x'),
    DELETE_CHILD(64, 'D'),
    READ_ATTRIBUTES(128, 't'),
    WRITE_ATTRIBUTES(256, 'T'),
    DELETE(65536, 'd'),
    READ_ACL(131072, 'c'),
    WRITE_ACL(262144, 'C'),
    WRITE_OWNER(524288, 'o'),
    SYNCHRONIZE(0x100000, 'y');

    private static final Map<Character, AccessMask> _values;
    private final int _value;
    private final char _label;

    private AccessMask(int value, char abbreviation) {
        this._value = value;
        this._label = abbreviation;
    }

    public int getValue() {
        return this._value;
    }

    public char getLabel() {
        return this._label;
    }

    public boolean matches(int accessMask) {
        return (this._value & accessMask) == this._value;
    }

    public static String asString(int accessMask) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        for (AccessMask accessMsk : AccessMask.values()) {
            if (!accessMsk.matches(accessMask)) continue;
            sb.append(accessMsk.getLabel());
        }
        return sb.toString();
    }

    static {
        _values = new HashMap<Character, AccessMask>();
        for (AccessMask mask : AccessMask.values()) {
            _values.put(Character.valueOf(mask.getLabel()), mask);
        }
    }
}

