/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.enums;

public enum Who {
    USER(0, "USER"),
    GROUP(1, "GROUP"),
    OWNER(2, "OWNER@"),
    OWNER_GROUP(3, "GROUP@"),
    EVERYONE(4, "EVERYONE@"),
    ANONYMOUS(5, "ANONYMOUS@"),
    AUTHENTICATED(6, "AUTHENTICATED@");

    private final int _value;
    private final String _abbreviation;

    private Who(int value, String abbreviation) {
        this._value = value;
        this._abbreviation = abbreviation;
    }

    public int getValue() {
        return this._value;
    }

    public String getAbbreviation() {
        return this._abbreviation;
    }

    public boolean equals(int value) {
        return this._value == value;
    }

    public boolean equals(String abbreviation) {
        return this._abbreviation.equals(abbreviation);
    }

    public boolean equalsIgnoreCase(String abbreviation) {
        return this._abbreviation.equalsIgnoreCase(abbreviation);
    }

    public static Who valueOf(int value) throws IllegalArgumentException {
        for (Who who : Who.values()) {
            if (who._value != value) continue;
            return who;
        }
        throw new IllegalArgumentException("Illegal argument (value of who): " + value);
    }

    public static Who fromAbbreviation(String abbreviation) throws IllegalArgumentException {
        if (abbreviation == null || abbreviation.length() == 0) {
            throw new IllegalArgumentException("Who abbreviation is " + (abbreviation == null ? "NULL" : "Empty"));
        }
        if (USER.equalsIgnoreCase(abbreviation)) {
            return USER;
        }
        if (GROUP.equalsIgnoreCase(abbreviation)) {
            return GROUP;
        }
        if (OWNER.equalsIgnoreCase(abbreviation)) {
            return OWNER;
        }
        if (OWNER_GROUP.equalsIgnoreCase(abbreviation)) {
            return OWNER_GROUP;
        }
        if (EVERYONE.equalsIgnoreCase(abbreviation)) {
            return EVERYONE;
        }
        if (ANONYMOUS.equalsIgnoreCase(abbreviation)) {
            return ANONYMOUS;
        }
        if (AUTHENTICATED.equalsIgnoreCase(abbreviation)) {
            return AUTHENTICATED;
        }
        if (abbreviation.endsWith("@")) {
            throw new IllegalArgumentException("Invalid who abbreviation: " + abbreviation);
        }
        return null;
    }
}

