/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.io.Closeable;
import java.util.List;
import org.dcache.acl.ACE;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInode_TAG;
import org.dcache.chimera.FsStat;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.store.AccessLatency;
import org.dcache.chimera.store.InodeStorageInformation;
import org.dcache.chimera.store.RetentionPolicy;

public interface FileSystemProvider
extends Closeable {
    public FsInode createLink(String var1, String var2) throws ChimeraFsException;

    public FsInode createLink(FsInode var1, String var2, String var3) throws ChimeraFsException;

    public FsInode createLink(FsInode var1, String var2, int var3, int var4, int var5, byte[] var6) throws ChimeraFsException;

    public FsInode createHLink(FsInode var1, FsInode var2, String var3) throws ChimeraFsException;

    public FsInode createFile(String var1) throws ChimeraFsException;

    public FsInode createFile(FsInode var1, String var2) throws ChimeraFsException;

    public FsInode createFileLevel(FsInode var1, int var2) throws ChimeraFsException;

    public FsInode createFile(FsInode var1, String var2, int var3, int var4, int var5) throws ChimeraFsException;

    public FsInode createFile(FsInode var1, String var2, int var3, int var4, int var5, int var6) throws ChimeraFsException;

    public void createFileWithId(FsInode var1, FsInode var2, String var3, int var4, int var5, int var6, int var7) throws ChimeraFsException;

    public DirectoryStreamB<HimeraDirectoryEntry> newDirectoryStream(FsInode var1) throws ChimeraFsException;

    public void remove(String var1) throws ChimeraFsException;

    public void remove(FsInode var1, String var2) throws ChimeraFsException;

    public void remove(FsInode var1) throws ChimeraFsException;

    public Stat stat(String var1) throws ChimeraFsException;

    public Stat stat(FsInode var1) throws ChimeraFsException;

    public Stat stat(FsInode var1, int var2) throws ChimeraFsException;

    public FsInode mkdir(String var1) throws ChimeraFsException;

    public FsInode mkdir(FsInode var1, String var2) throws ChimeraFsException;

    public FsInode mkdir(FsInode var1, String var2, int var3, int var4, int var5) throws ChimeraFsException;

    public FsInode path2inode(String var1) throws ChimeraFsException;

    public FsInode path2inode(String var1, FsInode var2) throws ChimeraFsException;

    public List<FsInode> path2inodes(String var1) throws ChimeraFsException;

    public List<FsInode> path2inodes(String var1, FsInode var2) throws ChimeraFsException;

    public FsInode inodeOf(FsInode var1, String var2) throws ChimeraFsException;

    public String inode2path(FsInode var1) throws ChimeraFsException;

    public String inode2path(FsInode var1, FsInode var2, boolean var3) throws ChimeraFsException;

    public boolean isIoEnabled(FsInode var1) throws ChimeraFsException;

    public boolean removeFileMetadata(String var1, int var2) throws ChimeraFsException;

    public FsInode getParentOf(FsInode var1) throws ChimeraFsException;

    public void setFileSize(FsInode var1, long var2) throws ChimeraFsException;

    public void setFileOwner(FsInode var1, int var2) throws ChimeraFsException;

    public void setFileOwner(FsInode var1, int var2, int var3) throws ChimeraFsException;

    public void setFileName(FsInode var1, String var2, String var3) throws ChimeraFsException;

    public void setInodeAttributes(FsInode var1, int var2, Stat var3) throws ChimeraFsException;

    public void setFileATime(FsInode var1, long var2) throws ChimeraFsException;

    public void setFileATime(FsInode var1, int var2, long var3) throws ChimeraFsException;

    public void setFileCTime(FsInode var1, long var2) throws ChimeraFsException;

    public void setFileCTime(FsInode var1, int var2, long var3) throws ChimeraFsException;

    public void setFileMTime(FsInode var1, long var2) throws ChimeraFsException;

    public void setFileMTime(FsInode var1, int var2, long var3) throws ChimeraFsException;

    public void setFileGroup(FsInode var1, int var2) throws ChimeraFsException;

    public void setFileGroup(FsInode var1, int var2, int var3) throws ChimeraFsException;

    public void setFileMode(FsInode var1, int var2) throws ChimeraFsException;

    public void setFileMode(FsInode var1, int var2, int var3) throws ChimeraFsException;

    public void setInodeIo(FsInode var1, boolean var2) throws ChimeraFsException;

    public int write(FsInode var1, int var2, long var3, byte[] var5, int var6, int var7) throws ChimeraFsException;

    public int read(FsInode var1, int var2, long var3, byte[] var5, int var6, int var7) throws ChimeraFsException;

    public byte[] readLink(String var1) throws ChimeraFsException;

    public byte[] readLink(FsInode var1) throws ChimeraFsException;

    public boolean move(String var1, String var2);

    public boolean move(FsInode var1, String var2, FsInode var3, String var4) throws ChimeraFsException;

    public List<StorageLocatable> getInodeLocations(FsInode var1, int var2) throws ChimeraFsException;

    public void addInodeLocation(FsInode var1, int var2, String var3) throws ChimeraFsException;

    public void clearInodeLocation(FsInode var1, int var2, String var3) throws ChimeraFsException;

    public String[] tags(FsInode var1) throws ChimeraFsException;

    public void createTag(FsInode var1, String var2) throws ChimeraFsException;

    public void createTag(FsInode var1, String var2, int var3, int var4, int var5) throws ChimeraFsException;

    public int setTag(FsInode var1, String var2, byte[] var3, int var4, int var5) throws ChimeraFsException;

    public void removeTag(FsInode var1, String var2) throws ChimeraFsException;

    public void removeTag(FsInode var1) throws ChimeraFsException;

    public int getTag(FsInode var1, String var2, byte[] var3, int var4, int var5) throws ChimeraFsException;

    public Stat statTag(FsInode var1, String var2) throws ChimeraFsException;

    public void setTagOwner(FsInode_TAG var1, String var2, int var3) throws ChimeraFsException;

    public void setTagOwnerGroup(FsInode_TAG var1, String var2, int var3) throws ChimeraFsException;

    public void setTagMode(FsInode_TAG var1, String var2, int var3) throws ChimeraFsException;

    public int getFsId();

    public void setStorageInfo(FsInode var1, InodeStorageInformation var2) throws ChimeraFsException;

    public void setAccessLatency(FsInode var1, AccessLatency var2) throws ChimeraFsException;

    public void setRetentionPolicy(FsInode var1, RetentionPolicy var2) throws ChimeraFsException;

    public InodeStorageInformation getStorageInfo(FsInode var1) throws ChimeraFsException;

    public AccessLatency getAccessLatency(FsInode var1) throws ChimeraFsException;

    public RetentionPolicy getRetentionPolicy(FsInode var1) throws ChimeraFsException;

    public void setInodeChecksum(FsInode var1, int var2, String var3) throws ChimeraFsException;

    public void removeInodeChecksum(FsInode var1, int var2) throws ChimeraFsException;

    public String getInodeChecksum(FsInode var1, int var2) throws ChimeraFsException;

    public String getInfo();

    public FsStat getFsStat() throws ChimeraFsException;

    public List<ACE> getACL(FsInode var1) throws ChimeraFsException;

    public void setACL(FsInode var1, List<ACE> var2) throws ChimeraFsException;

    public FsInode inodeFromBytes(byte[] var1) throws ChimeraFsException;

    public byte[] inodeToBytes(FsInode var1) throws ChimeraFsException;
}

