/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v3;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.v3.xdr.fattr3;
import org.dcache.nfs.v3.xdr.fileid3;
import org.dcache.nfs.v3.xdr.gid3;
import org.dcache.nfs.v3.xdr.mode3;
import org.dcache.nfs.v3.xdr.nfstime3;
import org.dcache.nfs.v3.xdr.post_op_attr;
import org.dcache.nfs.v3.xdr.pre_op_attr;
import org.dcache.nfs.v3.xdr.sattr3;
import org.dcache.nfs.v3.xdr.size3;
import org.dcache.nfs.v3.xdr.specdata3;
import org.dcache.nfs.v3.xdr.uid3;
import org.dcache.nfs.v3.xdr.uint32;
import org.dcache.nfs.v3.xdr.uint64;
import org.dcache.nfs.v3.xdr.wcc_attr;
import org.dcache.nfs.v3.xdr.wcc_data;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HimeraNfsUtils {
    private static final int MODE_MASK = 258048;
    private static final Logger _log = LoggerFactory.getLogger(HimeraNfsUtils.class);

    private HimeraNfsUtils() {
    }

    public static void fill_attributes(Stat stat, fattr3 at) {
        at.type = HimeraNfsUtils.unixType2NFS(stat.getMode());
        at.mode = new mode3(new uint32(stat.getMode() & 0x3FFFF));
        at.nlink = new uint32(stat.getNlink());
        at.uid = new uid3(new uint32(stat.getUid()));
        at.gid = new gid3(new uint32(stat.getGid()));
        at.rdev = new specdata3();
        at.rdev.specdata1 = new uint32(19);
        at.rdev.specdata2 = new uint32(17);
        at.fsid = new uint64(stat.getDev());
        at.fileid = new fileid3(new uint64(stat.getFileId()));
        at.size = new size3(new uint64(stat.getSize()));
        at.used = new size3(new uint64(stat.getSize()));
        at.atime = new nfstime3();
        at.atime.seconds = new uint32((int)TimeUnit.SECONDS.convert(stat.getATime(), TimeUnit.MILLISECONDS));
        at.atime.nseconds = new uint32(0);
        at.mtime = new nfstime3();
        at.mtime.seconds = new uint32((int)TimeUnit.SECONDS.convert(stat.getMTime(), TimeUnit.MILLISECONDS));
        at.mtime.nseconds = new uint32(0);
        at.ctime = new nfstime3();
        at.ctime.seconds = new uint32((int)TimeUnit.SECONDS.convert(stat.getCTime(), TimeUnit.MILLISECONDS));
        at.ctime.nseconds = new uint32(0);
    }

    public static void fill_attributes(Stat stat, wcc_attr at) {
        at.size = new size3(new uint64(stat.getSize()));
        at.mtime = new nfstime3();
        at.mtime.seconds = new uint32((int)TimeUnit.SECONDS.convert(stat.getMTime(), TimeUnit.MILLISECONDS));
        at.mtime.nseconds = new uint32(0);
        at.ctime = new nfstime3();
        at.ctime.seconds = new uint32((int)TimeUnit.SECONDS.convert(stat.getCTime(), TimeUnit.MILLISECONDS));
        at.ctime.nseconds = new uint32(0);
    }

    public static void set_sattr(Inode inode, VirtualFileSystem fs, sattr3 s) throws IOException {
        Stat stat = fs.getattr(inode);
        long now = System.currentTimeMillis();
        if (s.uid.set_it) {
            stat.setUid(s.uid.uid.value.value);
        }
        if (s.gid.set_it) {
            stat.setGid(s.gid.gid.value.value);
        }
        if (s.mode.set_it) {
            int mode = s.mode.mode.value.value | stat.getMode() & 0x3F000;
            _log.debug("New mode [{}]", (Object)Integer.toOctalString(mode));
            stat.setMode(mode);
        }
        if (s.size.set_it) {
            stat.setSize(s.size.size.value.value);
        }
        switch (s.mtime.set_it) {
            case 1: {
                stat.setMTime(now);
                break;
            }
            case 2: {
                long mtime = TimeUnit.MILLISECONDS.convert(s.mtime.mtime.seconds.value, TimeUnit.SECONDS) + TimeUnit.MILLISECONDS.convert(s.mtime.mtime.nseconds.value, TimeUnit.NANOSECONDS);
                stat.setMTime(mtime);
                break;
            }
        }
        fs.setattr(inode, stat);
    }

    static int unixType2NFS(int type) {
        int ret = 0;
        switch (type & 0x3F000) {
            case 32768: {
                ret = 1;
                break;
            }
            case 16384: {
                ret = 2;
                break;
            }
            case 40960: {
                ret = 5;
                break;
            }
            case 49152: {
                ret = 6;
                break;
            }
            case 24576: {
                ret = 3;
                break;
            }
            case 8192: {
                ret = 4;
                break;
            }
            case 4096: {
                ret = 7;
                break;
            }
            default: {
                _log.info("Unknown mode [{}]", (Object)Integer.toOctalString(type));
                ret = 0;
            }
        }
        return ret;
    }

    public static post_op_attr defaultPostOpAttr() {
        post_op_attr postOpAttr = new post_op_attr();
        postOpAttr.attributes_follow = false;
        return postOpAttr;
    }

    public static pre_op_attr defaultPreOpAttr() {
        pre_op_attr preOpAttr = new pre_op_attr();
        preOpAttr.attributes_follow = false;
        return preOpAttr;
    }

    public static wcc_data defaultWccData() {
        wcc_data wccData = new wcc_data();
        wccData.after = HimeraNfsUtils.defaultPostOpAttr();
        wccData.before = HimeraNfsUtils.defaultPreOpAttr();
        return wccData;
    }
}

