/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.CLOSE4res;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCLOSE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationCLOSE.class);

    OperationCLOSE(nfs_argop4 args) {
        super(args, 4);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        CLOSE4res res = result.opclose;
        Inode inode = context.currentInode();
        NFS4Client client = context.getMinorversion() > 0 ? context.getSession().getClient() : context.getStateHandler().getClientIdByStateId(this._args.opclose.open_stateid);
        client.releaseState(this._args.opclose.open_stateid);
        client.updateLeaseTime();
        if (context.getMinorversion() > 0) {
            context.getDeviceManager().layoutReturn(context, this._args.opclose.open_stateid);
        }
        res.open_stateid = Stateids.invalidStateId();
        res.status = 0;
    }
}

