/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.OperationSECINFO_NO_NAME;
import org.dcache.nfs.v4.xdr.SECINFO4res;
import org.dcache.nfs.v4.xdr.SECINFO4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSECINFO
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationSECINFO.class);

    OperationSECINFO(nfs_argop4 args) {
        super(args, 33);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        SECINFO4res res = result.opsecinfo;
        Inode inode = context.currentInode();
        context.clearCurrentInode();
        Stat stat = context.getFs().getattr(inode);
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new ChimeraNFSException(20, "not a directory");
        }
        try {
            res.resok4 = new SECINFO4resok();
            res.resok4.value = OperationSECINFO_NO_NAME.secinfosOf(inode, context);
            res.status = 0;
        }
        catch (GSSException e) {
            throw new ChimeraNFSException(5, e.getMessage());
        }
    }
}

