/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.net.InetAddress;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.SECINFO4resok;
import org.dcache.nfs.v4.xdr.SECINFO_NO_NAME4res;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.qop4;
import org.dcache.nfs.v4.xdr.rpcsec_gss_info;
import org.dcache.nfs.v4.xdr.sec_oid4;
import org.dcache.nfs.v4.xdr.secinfo4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.vfs.Inode;
import org.dcache.xdr.OncRpcException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class OperationSECINFO_NO_NAME
extends AbstractNFSv4Operation {
    private static final uint32_t DEFAULT_QOP = new uint32_t(0);
    private static final String K5OID = "1.2.840.113554.1.2.2";
    private static final Function<FsExport, FsExport.Sec> EXTRACT_SEC = new ExtractSec();

    public OperationSECINFO_NO_NAME(nfs_argop4 args) {
        super(args, 52);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        try {
            SECINFO_NO_NAME4res res = result.opsecinfo_no_name;
            Inode inode = context.currentInode();
            switch (this._args.opsecinfo_no_name.value) {
                case 0: 
                case 1: {
                    res.status = 0;
                    res.resok4 = new SECINFO4resok();
                    res.resok4.value = OperationSECINFO_NO_NAME.secinfosOf(inode, context);
                    break;
                }
                default: {
                    throw new ChimeraNFSException(10036, "bad type: " + this._args.opsecinfo_no_name.value);
                }
            }
        }
        catch (GSSException e) {
            throw new ChimeraNFSException(5, e.getMessage());
        }
    }

    static secinfo4[] secinfosOf(Inode inode, CompoundContext context) throws GSSException {
        InetAddress remote = context.getRpcCall().getTransport().getRemoteSocketAddress().getAddress();
        ImmutableList<FsExport.Sec> exports2 = Ordering.natural().reverse().immutableSortedCopy(Iterables.transform(context.getExportFile().exportsFor(remote), EXTRACT_SEC));
        secinfo4[] secinfos = new secinfo4[exports2.size()];
        for (int i = 0; i < secinfos.length; ++i) {
            secinfos[i] = OperationSECINFO_NO_NAME.toSecinfo((FsExport.Sec)((Object)exports2.get(i)));
        }
        return secinfos;
    }

    private static rpcsec_gss_info gssInfoOf(FsExport.Sec sec) throws GSSException {
        rpcsec_gss_info gssInfo = new rpcsec_gss_info();
        Oid oid = new Oid(K5OID);
        gssInfo.oid = new sec_oid4(oid.getDER());
        gssInfo.qop = new qop4(DEFAULT_QOP);
        switch (sec) {
            case KRB5: {
                gssInfo.service = 1;
                break;
            }
            case KRB5I: {
                gssInfo.service = 2;
                break;
            }
            case KRB5P: {
                gssInfo.service = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad flavor: " + (Object)((Object)sec));
            }
        }
        return gssInfo;
    }

    private static secinfo4 toSecinfo(FsExport.Sec sec) throws GSSException {
        secinfo4 secinfo = new secinfo4();
        switch (sec) {
            case NONE: {
                secinfo.flavor = 0;
                break;
            }
            case SYS: {
                secinfo.flavor = 1;
                break;
            }
            case KRB5: 
            case KRB5I: 
            case KRB5P: {
                secinfo.flavor = 6;
                secinfo.flavor_info = OperationSECINFO_NO_NAME.gssInfoOf(sec);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad flavor: " + (Object)((Object)sec));
            }
        }
        return secinfo;
    }

    private static class ExtractSec
    implements Function<FsExport, FsExport.Sec> {
        private ExtractSec() {
        }

        @Override
        public FsExport.Sec apply(FsExport input) {
            return input.getSec();
        }
    }
}

