/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.xdr.SETCLIENTID4res;
import org.dcache.nfs.v4.xdr.SETCLIENTID4resok;
import org.dcache.nfs.v4.xdr.clientaddr4;
import org.dcache.nfs.v4.xdr.clientid4;
import org.dcache.nfs.v4.xdr.netaddr4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.v4.xdr.verifier4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSETCLIENTID
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationSETCLIENTID.class);

    OperationSETCLIENTID(nfs_argop4 args) {
        super(args, 35);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        SETCLIENTID4res res = result.opsetclientid;
        verifier4 verifier = this._args.opsetclientid.client.verifier;
        NFS4Client client = context.getStateHandler().getClientByVerifier(verifier);
        if (client != null) {
            netaddr4 addr = new netaddr4(client.getRemoteAddress());
            res.status = 10017;
            res.client_using = new clientaddr4(addr);
            throw new ChimeraNFSException(10017, "Client Id In use");
        }
        client = context.getStateHandler().createClient(context.getRpcCall().getTransport().getRemoteSocketAddress(), context.getRpcCall().getTransport().getLocalSocketAddress(), this._args.opsetclientid.client.id, this._args.opsetclientid.client.verifier, null);
        res.resok4 = new SETCLIENTID4resok();
        res.resok4.clientid = new clientid4();
        res.resok4.clientid.value = new uint64_t(client.getId());
        res.resok4.setclientid_confirm = client.verifier();
        res.status = 0;
    }
}

