/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;

public class VfsCache
implements VirtualFileSystem {
    private final LoadingCache<CacheKey, Inode> _lookupCache;
    private final VirtualFileSystem _inner;

    public VfsCache(VirtualFileSystem inner) {
        this._inner = inner;
        this._lookupCache = CacheBuilder.newBuilder().maximumSize(8192L).expireAfterWrite(1L, TimeUnit.MINUTES).build(new FsCacheLoader());
    }

    @Override
    public int write(Inode inode, byte[] data, long offset, int count) throws IOException {
        return this._inner.write(inode, data, offset, count);
    }

    @Override
    public Inode symlink(Inode parent, String path, String link, int uid, int gid, int mode) throws IOException {
        return this._inner.symlink(parent, path, link, uid, gid, mode);
    }

    @Override
    public void remove(Inode parent, String path) throws IOException {
        this._inner.remove(parent, path);
        this.invalidateCache(parent, path);
    }

    @Override
    public String readlink(Inode inode) throws IOException {
        return this._inner.readlink(inode);
    }

    @Override
    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        return this._inner.read(inode, data, offset, count);
    }

    @Override
    public Inode parentOf(Inode inode) throws IOException {
        return this._inner.parentOf(inode);
    }

    @Override
    public void move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        this.invalidateCache(src, oldName);
        this.invalidateCache(dest, newName);
        this._inner.move(src, oldName, dest, newName);
    }

    @Override
    public Inode mkdir(Inode parent, String path, int uid, int gid, int mode) throws IOException {
        Inode inode = this._inner.mkdir(parent, path, uid, gid, mode);
        this.updateCache(parent, path, inode);
        return inode;
    }

    @Override
    public List<DirectoryEntry> list(Inode inode) throws IOException {
        return this._inner.list(inode);
    }

    @Override
    public Inode link(Inode parent, Inode link, String path, int uid, int gid) throws IOException {
        Inode inode = this._inner.link(parent, link, path, uid, gid);
        this.updateCache(parent, path, inode);
        return inode;
    }

    @Override
    public Inode lookup(Inode parent, String path) throws IOException {
        return this.getFromCache(parent, path);
    }

    @Override
    public Inode getRootInode() throws IOException {
        return this._inner.getRootInode();
    }

    @Override
    public FsStat getFsStat() throws IOException {
        return this._inner.getFsStat();
    }

    @Override
    public Inode create(Inode parent, Stat.Type type, String path, int uid, int gid, int mode) throws IOException {
        Inode inode = this._inner.create(parent, type, path, uid, gid, mode);
        this.updateCache(parent, path, inode);
        return inode;
    }

    private Inode getFromCache(Inode parent, String path) throws IOException {
        try {
            return this._lookupCache.getUnchecked(new CacheKey(parent, path));
        }
        catch (UncheckedExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(e.getMessage(), t);
        }
    }

    private void invalidateCache(Inode parent, String path) {
        this._lookupCache.invalidate(new CacheKey(parent, path));
    }

    private void updateCache(Inode parent, String path, Inode inode) {
        this._lookupCache.asMap().put(new CacheKey(parent, path), inode);
    }

    @Override
    public int access(Inode inode, int mode) throws IOException {
        return this._inner.access(inode, mode);
    }

    @Override
    public Stat getattr(Inode inode) throws IOException {
        return this._inner.getattr(inode);
    }

    @Override
    public void setattr(Inode inode, Stat stat) throws IOException {
        this._inner.setattr(inode, stat);
    }

    @Override
    public nfsace4[] getAcl(Inode inode) throws IOException {
        return this._inner.getAcl(inode);
    }

    @Override
    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
        this._inner.setAcl(inode, acl);
    }

    @Override
    public boolean hasIOLayout(Inode inode) throws IOException {
        return this._inner.hasIOLayout(inode);
    }

    private class FsCacheLoader
    extends CacheLoader<CacheKey, Inode> {
        private FsCacheLoader() {
        }

        @Override
        public Inode load(CacheKey k) throws Exception {
            return VfsCache.this._inner.lookup(k.getParent(), k.getName());
        }
    }

    private static class CacheKey {
        private final Inode _parent;
        private final String _name;

        public CacheKey(Inode parent, String name2) {
            this._parent = parent;
            this._name = name2;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return other._parent.equals(this._parent) & other._name.equals(this._name);
        }

        public int hashCode() {
            return this._name.hashCode() ^ this._parent.hashCode();
        }

        public String getName() {
            return this._name;
        }

        public Inode getParent() {
            return this._parent;
        }
    }
}

