/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.utils;

import com.google.common.cache.Cache;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.dcache.utils.GuavaCacheMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaCacheMXBeanImpl
implements GuavaCacheMXBean {
    private static final Logger _log = LoggerFactory.getLogger(GuavaCacheMXBeanImpl.class);
    private final Cache _cache;

    public GuavaCacheMXBeanImpl(String cname, Cache cache) {
        this._cache = cache;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            String name2 = String.format("%s:type=Cache,name=%s", this._cache.getClass().getPackage().getName(), cname);
            ObjectName mxBeanName = new ObjectName(name2);
            if (!server.isRegistered(mxBeanName)) {
                server.registerMBean(this, new ObjectName(name2));
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException ex) {
            _log.warn("Failed to create JMX bean: {}", (Object)ex.getMessage());
        }
    }

    @Override
    public long getRequestCount() {
        return this._cache.stats().requestCount();
    }

    @Override
    public long getHitCount() {
        return this._cache.stats().hitCount();
    }

    @Override
    public double getHitRate() {
        return this._cache.stats().hitRate();
    }

    @Override
    public long getMissCount() {
        return this._cache.stats().missCount();
    }

    @Override
    public double getMissRate() {
        return this._cache.stats().missRate();
    }

    @Override
    public long getLoadCount() {
        return this._cache.stats().loadCount();
    }

    @Override
    public long getLoadSuccessCount() {
        return this._cache.stats().loadSuccessCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this._cache.stats().loadExceptionCount();
    }

    @Override
    public double getLoadExceptionRate() {
        return this._cache.stats().loadExceptionRate();
    }

    @Override
    public long getTotalLoadTime() {
        return this._cache.stats().totalLoadTime();
    }

    @Override
    public double getAverageLoadPenalty() {
        return this._cache.stats().averageLoadPenalty();
    }

    @Override
    public long getEvictionCount() {
        return this._cache.stats().evictionCount();
    }

    @Override
    public long getSize() {
        return this._cache.size();
    }

    @Override
    public void cleanUp() {
        this._cache.cleanUp();
    }

    @Override
    public void invalidateAll() {
        this._cache.invalidateAll();
    }
}

