/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dcache.utils.net.InetSocketAddresses;
import org.dcache.xdr.GrizzlyUtils;
import org.dcache.xdr.OncRpcClient;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.OncRpcSvcBuilder;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.RpcDispatchable;
import org.dcache.xdr.RpcDispatcher;
import org.dcache.xdr.RpcProgUnavailable;
import org.dcache.xdr.RpcProtocolFilter;
import org.dcache.xdr.RpcReply;
import org.dcache.xdr.XdrTransport;
import org.dcache.xdr.gss.GssProtocolFilter;
import org.dcache.xdr.gss.GssSessionManager;
import org.dcache.xdr.portmap.GenericPortmapClient;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.SocketBinder;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.jmxbase.GrizzlyJmxManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncRpcSvc {
    private static final Logger _log = LoggerFactory.getLogger(OncRpcSvc.class);
    private final int _backlog;
    private final boolean _publish;
    private final PortRange _portRange;
    private final String _bindAddress;
    private final List<Transport> _transports = new ArrayList<Transport>();
    private final Set<Connection<InetSocketAddress>> _boundConnections = new HashSet<Connection<InetSocketAddress>>();
    private final ReplyQueue<Integer, RpcReply> _replyQueue = new ReplyQueue();
    private GssSessionManager _gssSessionManager;
    private final Map<OncRpcProgram, RpcDispatchable> _programs = new ConcurrentHashMap<OncRpcProgram, RpcDispatchable>();

    OncRpcSvc(OncRpcSvcBuilder builder) {
        this._publish = builder.isAutoPublish();
        int protocol = builder.getProtocol();
        if ((protocol & 0x17) == 0) {
            throw new IllegalArgumentException("TCP or UDP protocol have to be defined");
        }
        IOStrategy grizzlyIoStrategy = builder.getIoStrategy().getStrategy();
        if ((protocol & 6) != 0) {
            TCPNIOTransport tcpTransport = ((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setReuseAddress(true).setIOStrategy(grizzlyIoStrategy)).build();
            this._transports.add(tcpTransport);
        }
        if ((protocol & 0x11) != 0) {
            UDPNIOTransport udpTransport = ((UDPNIOTransportBuilder)UDPNIOTransportBuilder.newInstance().setReuseAddress(true).setIOStrategy(grizzlyIoStrategy)).build();
            this._transports.add(udpTransport);
        }
        this._portRange = new PortRange(builder.getMinPort(), builder.getMaxPort());
        this._backlog = builder.getBacklog();
        this._bindAddress = builder.getBindAddress();
        if (builder.isWithJMX()) {
            GrizzlyJmxManager jmxManager = GrizzlyJmxManager.instance();
            for (Transport t : this._transports) {
                jmxManager.registerAtRoot(t.getMonitoringConfig().createManagementObject(), t.getName() + "-" + this._portRange);
            }
        }
    }

    public void register(OncRpcProgram prog, RpcDispatchable handler) {
        _log.info("Registering new program {} : {}", (Object)prog, (Object)handler);
        this._programs.put(prog, handler);
    }

    public void unregister(OncRpcProgram prog) {
        _log.info("Unregistering program {}", (Object)prog);
        this._programs.remove(prog);
    }

    public void setPrograms(Map<OncRpcProgram, RpcDispatchable> services) {
        this._programs.putAll(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishToPortmap(Connection<InetSocketAddress> connection, Set<OncRpcProgram> programs) throws IOException {
        OncRpcClient rpcClient = new OncRpcClient(InetAddress.getByName(null), 17, 111);
        XdrTransport transport = rpcClient.connect();
        try {
            GenericPortmapClient portmapClient = new GenericPortmapClient(transport);
            String username = System.getProperty("user.name");
            Transport t = connection.getTransport();
            String uaddr = InetSocketAddresses.uaddrOf(connection.getLocalAddress());
            for (OncRpcProgram program : programs) {
                try {
                    if (t instanceof TCPNIOTransport) {
                        portmapClient.setPort(program.getNumber(), program.getVersion(), "tcp", uaddr, username);
                    }
                    if (!(t instanceof UDPNIOTransport)) continue;
                    portmapClient.setPort(program.getNumber(), program.getVersion(), "udp", uaddr, username);
                }
                catch (OncRpcException ex) {
                    _log.error("Failed to register program", ex);
                }
            }
        }
        catch (RpcProgUnavailable e) {
            _log.warn("Failed to register at portmap: ", (Object)e.getMessage());
        }
        finally {
            rpcClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPortmap(Set<OncRpcProgram> programs) throws IOException {
        OncRpcClient rpcClient = new OncRpcClient(InetAddress.getByName(null), 17, 111);
        XdrTransport transport = rpcClient.connect();
        try {
            GenericPortmapClient portmapClient = new GenericPortmapClient(transport);
            String username = System.getProperty("user.name");
            for (OncRpcProgram program : programs) {
                try {
                    portmapClient.unsetPort(program.getNumber(), program.getVersion(), username);
                }
                catch (OncRpcException ex) {
                    _log.info("Failed to unregister program {}", (Object)ex.getMessage());
                }
            }
        }
        catch (RpcProgUnavailable e) {
            _log.info("portmap service not available");
        }
        finally {
            rpcClient.close();
        }
    }

    public void setGssSessionManager(GssSessionManager gssSessionManager) {
        this._gssSessionManager = gssSessionManager;
    }

    public void start() throws IOException {
        if (this._publish) {
            this.clearPortmap(this._programs.keySet());
        }
        for (Transport t : this._transports) {
            FilterChainBuilder filterChain = FilterChainBuilder.stateless();
            filterChain.add(new TransportFilter());
            filterChain.add(GrizzlyUtils.rpcMessageReceiverFor(t));
            filterChain.add(new RpcProtocolFilter(this._replyQueue));
            if (this._gssSessionManager != null) {
                filterChain.add(new GssProtocolFilter(this._gssSessionManager));
            }
            filterChain.add(new RpcDispatcher(this._programs));
            FilterChain filters = filterChain.build();
            t.setProcessor(filters);
            Connection connection = ((SocketBinder)((Object)t)).bind(this._bindAddress, this._portRange, this._backlog);
            t.start();
            this._boundConnections.add(connection);
            if (!this._publish) continue;
            this.publishToPortmap(connection, this._programs.keySet());
        }
    }

    public void stop() throws IOException {
        if (this._publish) {
            this.clearPortmap(this._programs.keySet());
        }
        for (Transport t : this._transports) {
            t.shutdownNow();
        }
    }

    public InetSocketAddress getInetSocketAddress(int protocol) {
        Class<? extends Transport> transportClass = GrizzlyUtils.transportFor(protocol);
        for (Connection<InetSocketAddress> connection : this._boundConnections) {
            if (connection.getTransport().getClass() != transportClass) continue;
            return connection.getLocalAddress();
        }
        return null;
    }

    public static enum IoStrategy {
        SAME_THREAD{

            @Override
            IOStrategy getStrategy() {
                return SameThreadIOStrategy.getInstance();
            }
        }
        ,
        WORKER_THREAD{

            @Override
            IOStrategy getStrategy() {
                return WorkerThreadIOStrategy.getInstance();
            }
        };


        abstract IOStrategy getStrategy();
    }
}

