/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import com.google.common.base.Preconditions;
import org.dcache.xdr.OncRpcSvc;

public class OncRpcSvcBuilder {
    private int _protocol = 0;
    private int _minPort = 0;
    private int _maxPort = 0;
    private boolean _autoPublish = true;
    private OncRpcSvc.IoStrategy _ioStrategy = OncRpcSvc.IoStrategy.SAME_THREAD;
    private boolean _withJMX = false;
    private int _backlog = 4096;
    private String _bindAddress = "0.0.0.0";

    public OncRpcSvcBuilder withAutoPublish() {
        this._autoPublish = true;
        return this;
    }

    public OncRpcSvcBuilder withoutAutoPublish() {
        this._autoPublish = false;
        return this;
    }

    public OncRpcSvcBuilder withMaxPort(int maxPort) {
        Preconditions.checkArgument(maxPort >= 0, "Illegal max port value");
        this._maxPort = maxPort;
        this._minPort = Math.min(this._minPort, this._maxPort);
        return this;
    }

    public OncRpcSvcBuilder withMinPort(int minPort) {
        Preconditions.checkArgument(minPort >= 0, "Illegal min port value");
        this._minPort = minPort;
        this._maxPort = Math.max(this._minPort, this._maxPort);
        return this;
    }

    public OncRpcSvcBuilder withPort(int port) {
        Preconditions.checkArgument(port >= 0, "Illegal port value");
        this._minPort = this._maxPort = port;
        return this;
    }

    public OncRpcSvcBuilder withTCP() {
        this._protocol |= 6;
        return this;
    }

    public OncRpcSvcBuilder withUDP() {
        this._protocol |= 0x11;
        return this;
    }

    public OncRpcSvcBuilder withSameThreadIoStrategy() {
        this._ioStrategy = OncRpcSvc.IoStrategy.SAME_THREAD;
        return this;
    }

    public OncRpcSvcBuilder withWorkerThreadIoStrategy() {
        this._ioStrategy = OncRpcSvc.IoStrategy.WORKER_THREAD;
        return this;
    }

    public OncRpcSvcBuilder withJMX() {
        this._withJMX = true;
        return this;
    }

    public OncRpcSvcBuilder withBacklog(int backlog) {
        this._backlog = backlog;
        return this;
    }

    public OncRpcSvcBuilder withBindAddress(String address) {
        this._bindAddress = address;
        return this;
    }

    public int getProtocol() {
        return this._protocol;
    }

    public int getMinPort() {
        return this._minPort;
    }

    public int getMaxPort() {
        return this._maxPort;
    }

    public boolean isAutoPublish() {
        return this._autoPublish;
    }

    public OncRpcSvc.IoStrategy getIoStrategy() {
        return this._ioStrategy;
    }

    public boolean isWithJMX() {
        return this._withJMX;
    }

    public int getBacklog() {
        return this._backlog;
    }

    public String getBindAddress() {
        return this._bindAddress;
    }

    public OncRpcSvc build() {
        if (this._protocol == 0) {
            throw new IllegalArgumentException("invalid protocol");
        }
        return new OncRpcSvc(this);
    }
}

