/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import org.glassfish.gmbal.AMXClient;
import org.glassfish.gmbal.AMXMBeanInterface;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.MBeanImpl;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.pfl.basic.algorithm.Algorithms;
import org.glassfish.pfl.basic.func.UnaryFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXImpl
implements AMXMBeanInterface {
    private MBeanImpl mbean;
    private static UnaryFunction<MBeanImpl, AMXMBeanInterface> extract = new UnaryFunction<MBeanImpl, AMXMBeanInterface>(){

        @Override
        public AMXMBeanInterface evaluate(MBeanImpl mb) {
            return mb.facet(AMXMBeanInterface.class);
        }
    };

    public AMXImpl(MBeanImpl mb) {
        this.mbean = mb;
    }

    @Override
    public String getName() {
        return this.mbean.name();
    }

    @Override
    public Map<String, ?> getMeta() {
        Descriptor desc;
        MBeanInfo mbi = this.mbean.getMBeanInfo();
        ModelMBeanInfoSupport mmbi = (ModelMBeanInfoSupport)mbi;
        try {
            desc = mmbi.getMBeanDescriptor();
        }
        catch (MBeanException ex) {
            throw Exceptions.self.excForGetMeta(ex);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : desc.getFieldNames()) {
            result.put(key, desc.getFieldValue(key));
        }
        return result;
    }

    @Override
    public AMXMBeanInterface getParent() {
        MBeanImpl parent = this.mbean.parent();
        if (parent != null) {
            return parent.facet(AMXMBeanInterface.class);
        }
        ManagedObjectManagerInternal mom = this.mbean.skeleton().mom();
        ObjectName rpn = mom.getRootParentName();
        if (rpn == null) {
            return null;
        }
        return new AMXClient(mom.getMBeanServer(), rpn);
    }

    @Override
    public AMXMBeanInterface[] getChildren() {
        List<AMXMBeanInterface> children = this.getContained(this.mbean.children().keySet());
        return children.toArray(new AMXMBeanInterface[children.size()]);
    }

    private List<AMXMBeanInterface> getContained(Set<String> types) {
        ArrayList<AMXMBeanInterface> result = new ArrayList<AMXMBeanInterface>();
        for (String str : types) {
            result.addAll(Arrays.asList(this.getContained(str)));
        }
        return result;
    }

    private AMXMBeanInterface[] getContained(String type) {
        Collection<AMXMBeanInterface> children = Algorithms.map(this.mbean.children().get(type), extract).values();
        return children.toArray(new AMXMBeanInterface[children.size()]);
    }
}

