/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.glassfish.grizzly.AbstractBindingHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.utils.Exceptions;

public class UDPNIOBindingHandler
extends AbstractBindingHandler {
    private final UDPNIOTransport udpTransport;

    public UDPNIOBindingHandler(UDPNIOTransport udpTransport) {
        super(udpTransport);
        this.udpTransport = udpTransport;
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, -1);
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        return this.bindToChannel(this.udpTransport.getSelectorProvider().openDatagramChannel(), socketAddress);
    }

    @Override
    public UDPNIOServerConnection bindToInherited() throws IOException {
        return this.bindToChannel((DatagramChannel)this.getSystemInheritedChannel(DatagramChannel.class), null);
    }

    @Override
    public void unbind(Connection connection) {
        this.udpTransport.unbind(connection);
    }

    public static Builder builder(UDPNIOTransport transport) {
        return new Builder(transport);
    }

    private UDPNIOServerConnection bindToChannel(DatagramChannel serverDatagramChannel, SocketAddress socketAddress) throws IOException {
        NIOConnection serverConnection = null;
        ReentrantReadWriteLock.WriteLock lock = this.udpTransport.getState().getStateLocker().writeLock();
        lock.lock();
        try {
            DatagramSocket socket = serverDatagramChannel.socket();
            try {
                socket.setReuseAddress(this.udpTransport.isReuseAddress());
            }
            catch (IOException e) {
                UDPNIOTransport.LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_SOCKET_REUSEADDRESS_EXCEPTION(this.udpTransport.isReuseAddress()), e);
            }
            try {
                socket.setSoTimeout(this.udpTransport.getServerSocketSoTimeout());
            }
            catch (IOException e) {
                UDPNIOTransport.LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_SOCKET_TIMEOUT_EXCEPTION(this.udpTransport.getServerSocketSoTimeout()), e);
            }
            if (socketAddress != null) {
                socket.bind(socketAddress);
            }
            serverDatagramChannel.configureBlocking(false);
            serverConnection = this.udpTransport.obtainServerNIOConnection(serverDatagramChannel);
            serverConnection.setProcessor(this.getProcessor());
            serverConnection.setProcessorSelector(this.getProcessorSelector());
            this.udpTransport.serverConnections.add((UDPNIOServerConnection)serverConnection);
            if (!this.udpTransport.isStopped()) {
                ((UDPNIOServerConnection)serverConnection).register();
            }
            NIOConnection e = serverConnection;
            return e;
        }
        catch (Exception e) {
            if (serverConnection != null) {
                this.udpTransport.serverConnections.remove(serverConnection);
                serverConnection.closeSilently();
            } else {
                try {
                    serverDatagramChannel.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            throw Exceptions.makeIOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    public static class Builder
    extends AbstractBindingHandler.Builder<Builder> {
        public Builder(UDPNIOTransport transport) {
            super(new UDPNIOBindingHandler(transport));
        }

        public UDPNIOBindingHandler build() {
            return (UDPNIOBindingHandler)this.bindingHandler;
        }
    }
}

