/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.fsm;

import org.glassfish.pfl.basic.fsm.FSM;
import org.glassfish.pfl.basic.fsm.Input;
import org.glassfish.pfl.basic.fsm.NameBase;
import org.glassfish.pfl.basic.func.BinaryFunction;
import org.glassfish.pfl.basic.func.BinaryPredicate;

public interface Guard {
    public Result evaluate(FSM var1, Input var2);

    public static abstract class Base
    extends NameBase
    implements Guard {
        public static Guard makeGuard(final Predicate pred) {
            return new Base(pred.toString()){

                @Override
                public Result evaluate(FSM fsm, Input in) {
                    return pred.evaluate(fsm, in) ? Result.ENABLED : Result.DISABLED;
                }
            };
        }

        public static Predicate not(final Predicate pred) {
            return new Predicate("!" + pred.toString()){

                @Override
                public boolean evaluate(FSM fsm, Input in) {
                    return !pred.evaluate(fsm, in);
                }
            };
        }

        public static Predicate and(final Predicate arg1, final Predicate arg2) {
            return new Predicate("(" + arg1.toString() + "&&" + arg2.toString() + ")"){

                @Override
                public boolean evaluate(FSM fsm, Input in) {
                    if (!arg1.evaluate(fsm, in)) {
                        return false;
                    }
                    return arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate or(final Predicate arg1, final Predicate arg2) {
            return new Predicate("(" + arg1.toString() + "||" + arg2.toString() + ")"){

                @Override
                public boolean evaluate(FSM fsm, Input in) {
                    if (arg1.evaluate(fsm, in)) {
                        return true;
                    }
                    return arg2.evaluate(fsm, in);
                }
            };
        }

        public static IntFunc constant(final int val) {
            return new IntFunc("constant(" + val + ")"){

                @Override
                public Integer evaluate(FSM fsm, Input input) {
                    return val;
                }
            };
        }

        public static Predicate lt(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + "<" + arg2.toString() + ")"){

                @Override
                public boolean evaluate(FSM fsm, Input in) {
                    return (Integer)arg1.evaluate(fsm, in) < (Integer)arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate le(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + "<=" + arg2.toString() + ")"){

                @Override
                public boolean evaluate(FSM fsm, Input in) {
                    return (Integer)arg1.evaluate(fsm, in) <= (Integer)arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate gt(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + ">" + arg2.toString() + ")"){

                @Override
                public boolean evaluate(FSM fsm, Input in) {
                    return (Integer)arg1.evaluate(fsm, in) > (Integer)arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate ge(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + ">=" + arg2.toString() + ")"){

                @Override
                public boolean evaluate(FSM fsm, Input in) {
                    return (Integer)arg1.evaluate(fsm, in) >= (Integer)arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate eq(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + "==" + arg2.toString() + ")"){

                @Override
                public boolean evaluate(FSM fsm, Input in) {
                    return arg1.evaluate(fsm, in) == arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate ne(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + "!=" + arg2.toString() + ")"){

                @Override
                public boolean evaluate(FSM fsm, Input in) {
                    return arg1.evaluate(fsm, in) != arg2.evaluate(fsm, in);
                }
            };
        }

        public Base(String name2) {
            super(name2);
        }

        public static abstract class IntFunc
        extends SimpleName
        implements BinaryFunction<FSM, Input, Integer> {
            public IntFunc(String name2) {
                super(name2);
            }
        }

        public static abstract class Predicate
        extends SimpleName
        implements BinaryPredicate<FSM, Input> {
            public Predicate(String name2) {
                super(name2);
            }
        }

        public static abstract class SimpleName {
            private String name;

            public SimpleName(String name2) {
                this.name = name2;
            }

            public String toString() {
                return this.name;
            }
        }
    }

    public static enum Result {
        ENABLED,
        DISABLED,
        DEFERRED;

    }
}

