/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.pfl.objectweb.asm.AnnotationVisitor;

public class AnnotationNode
implements AnnotationVisitor {
    public String desc;
    public List values;

    public AnnotationNode(String desc) {
        this.desc = desc;
    }

    AnnotationNode(List values) {
        this.values = values;
    }

    @Override
    public void visit(String name2, Object value) {
        if (this.values == null) {
            this.values = new ArrayList(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        this.values.add(value);
    }

    @Override
    public void visitEnum(String name2, String desc, String value) {
        if (this.values == null) {
            this.values = new ArrayList(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        this.values.add(new String[]{desc, value});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name2, String desc) {
        if (this.values == null) {
            this.values = new ArrayList(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        AnnotationNode annotation = new AnnotationNode(desc);
        this.values.add(annotation);
        return annotation;
    }

    @Override
    public AnnotationVisitor visitArray(String name2) {
        if (this.values == null) {
            this.values = new ArrayList(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        ArrayList array = new ArrayList();
        this.values.add(array);
        return new AnnotationNode(array);
    }

    @Override
    public void visitEnd() {
    }

    public void accept(AnnotationVisitor av) {
        if (av != null) {
            if (this.values != null) {
                for (int i = 0; i < this.values.size(); i += 2) {
                    String name2 = (String)this.values.get(i);
                    Object value = this.values.get(i + 1);
                    AnnotationNode.accept(av, name2, value);
                }
            }
            av.visitEnd();
        }
    }

    static void accept(AnnotationVisitor av, String name2, Object value) {
        if (av != null) {
            if (value instanceof String[]) {
                String[] typeconst = (String[])value;
                av.visitEnum(name2, typeconst[0], typeconst[1]);
            } else if (value instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)value;
                an.accept(av.visitAnnotation(name2, an.desc));
            } else if (value instanceof List) {
                AnnotationVisitor v = av.visitArray(name2);
                List array = (List)value;
                for (int j = 0; j < array.size(); ++j) {
                    AnnotationNode.accept(v, null, array.get(j));
                }
                v.visitEnd();
            } else {
                av.visit(name2, value);
            }
        }
    }
}

