/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.pfl.tf.timer.impl.NamedBaseImpl;
import org.glassfish.pfl.tf.timer.impl.TimerFactoryImpl;
import org.glassfish.pfl.tf.timer.spi.Controllable;

public abstract class ControllableBase
extends NamedBaseImpl
implements Controllable {
    private static final Set<ControllableBase> emptyContent = Collections.unmodifiableSet(new HashSet());
    private int id;
    private String description;
    private boolean isEnabled;

    protected ControllableBase(int id, String name2, String description, TimerFactoryImpl factory) {
        super(factory, name2);
        this.id = id;
        this.description = description;
        this.isEnabled = false;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String description() {
        return this.description;
    }

    void description(String description) {
        this.description = description;
    }

    @Override
    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public Set<ControllableBase> contents() {
        return emptyContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enable() {
        TimerFactoryImpl timerFactoryImpl = this.factory();
        synchronized (timerFactoryImpl) {
            if (!this.isEnabled()) {
                this.isEnabled = true;
                this.factory().updateActivation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        TimerFactoryImpl timerFactoryImpl = this.factory();
        synchronized (timerFactoryImpl) {
            if (this.isEnabled()) {
                this.isEnabled = false;
                this.factory().updateActivation();
            }
        }
    }

    void transitiveClosure(Set<ControllableBase> result) {
        result.add(this);
        for (ControllableBase c : this.contents()) {
            if (result.contains(c)) continue;
            c.transitiveClosure(result);
        }
    }
}

