/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.impl;

import java.util.ArrayList;
import java.util.Stack;
import org.glassfish.pfl.tf.timer.impl.StatsEventHandlerBase;
import org.glassfish.pfl.tf.timer.spi.StatisticsAccumulator;
import org.glassfish.pfl.tf.timer.spi.Timer;
import org.glassfish.pfl.tf.timer.spi.TimerEvent;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;

public class MultiThreadedStatsEventHandlerImpl
extends StatsEventHandlerBase {
    private Object saListLock;
    private ThreadLocal<ArrayList<Stack<TimerEvent>>> tlsteList;

    MultiThreadedStatsEventHandlerImpl(TimerFactory factory, String name2) {
        super(factory, name2);
        final int size = factory.numberOfIds();
        this.saListLock = new Object();
        this.tlsteList = new ThreadLocal<ArrayList<Stack<TimerEvent>>>(){

            @Override
            public ArrayList<Stack<TimerEvent>> initialValue() {
                ArrayList<Stack<TimerEvent>> result = new ArrayList<Stack<TimerEvent>>(size);
                for (int ctr = 0; ctr < size; ++ctr) {
                    result.add(new Stack());
                }
                return result;
            }
        };
    }

    private Stack<TimerEvent> getSteElement(int id) {
        ArrayList<Stack<TimerEvent>> ste = this.tlsteList.get();
        ste.ensureCapacity(id + 1);
        for (int ctr = ste.size(); ctr <= id; ++ctr) {
            ste.add(new Stack());
        }
        return ste.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.saListLock;
        synchronized (object) {
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recordDuration(int id, long duration) {
        Object object = this.saListLock;
        synchronized (object) {
            StatisticsAccumulator acc = (StatisticsAccumulator)this.saList.get(id);
            acc.sample(duration);
        }
    }

    @Override
    public void notify(TimerEvent event) {
        Timer timer = event.timer();
        int id = timer.id();
        this.notify(this.getSteElement(id), event);
    }
}

