/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.tools.enhancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.pfl.basic.tools.file.FileWrapper;
import org.glassfish.pfl.basic.tools.file.Scanner;
import org.glassfish.pfl.objectweb.asm.AnnotationVisitor;
import org.glassfish.pfl.objectweb.asm.ClassReader;
import org.glassfish.pfl.objectweb.asm.FieldVisitor;
import org.glassfish.pfl.objectweb.asm.MethodVisitor;
import org.glassfish.pfl.objectweb.asm.Type;
import org.glassfish.pfl.objectweb.asm.commons.EmptyVisitor;
import org.glassfish.pfl.tf.spi.Util;
import org.glassfish.pfl.tf.spi.annotation.MethodMonitorGroup;
import org.glassfish.pfl.tf.timer.spi.TimingInfoProcessor;

public class AnnotationScannerAction
implements Scanner.Action {
    private static Class<MethodMonitorGroup> MMG_CLASS = MethodMonitorGroup.class;
    private static String MMG_DESCRIPTOR = Type.getType(MMG_CLASS).getDescriptor();
    private final Util util;
    private final TimingInfoProcessor tip;
    private Set<String> annotationNames = new HashSet<String>();
    private String currentClass;

    AnnotationScannerAction(Util util, TimingInfoProcessor tip) {
        this.util = util;
        this.tip = tip;
    }

    public Set<String> getAnnotationNames() {
        return this.annotationNames;
    }

    @Override
    public boolean evaluate(FileWrapper fw) {
        try {
            byte[] inputData = fw.readAll();
            ClassReader cr = new ClassReader(inputData);
            AnnoScanner as = new AnnoScanner();
            cr.accept(as, 0);
        }
        catch (IOException ex) {
            return true;
        }
        return true;
    }

    private class AnnoScanner
    extends EmptyVisitor {
        private boolean visitingAnnotation = false;
        private String annotationValueName = null;
        private String timerGroupDescription;
        private String timerGroupName;
        private List<Type> timerGroupMembers;

        private AnnoScanner() {
        }

        @Override
        public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
            AnnotationScannerAction.this.util.info(3, "Visiting class " + name2);
            if ((access & 0x2000) == 8192) {
                AnnotationScannerAction.this.util.info(2, "\t(Annotation)");
                AnnotationScannerAction.this.currentClass = name2;
            }
        }

        private String getGroupName(String desc) {
            String result = desc;
            int index = desc.lastIndexOf(47);
            if (index >= 0) {
                result = desc.substring(index + 1);
            }
            return result;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationScannerAction.this.util.info(3, "\tVisiting annotation " + desc);
            if (desc.equals(MMG_DESCRIPTOR)) {
                AnnotationScannerAction.this.annotationNames.add(AnnotationScannerAction.this.currentClass);
                this.visitingAnnotation = true;
                this.timerGroupName = this.getGroupName(AnnotationScannerAction.this.currentClass);
                this.timerGroupDescription = "TimerGroup for Annotation " + this.timerGroupName;
                this.timerGroupMembers = new ArrayList<Type>();
                return this;
            }
            return null;
        }

        @Override
        public void visit(String name2, Object value) {
            if (name2 == null) {
                if (this.annotationValueName.equals("value")) {
                    this.timerGroupMembers.add((Type)value);
                }
            } else if (name2.equals("description")) {
                if (value instanceof String) {
                    this.timerGroupDescription = (String)value;
                }
            } else if (name2.equals("value") && value instanceof Type[]) {
                this.timerGroupMembers = Arrays.asList((Type[])value);
            }
        }

        @Override
        public AnnotationVisitor visitArray(String name2) {
            this.annotationValueName = name2;
            return this;
        }

        @Override
        public void visitEnd() {
            if (this.visitingAnnotation) {
                this.visitingAnnotation = false;
                AnnotationScannerAction.this.tip.addTimerGroup(this.timerGroupName, this.timerGroupDescription);
                for (Type type : this.timerGroupMembers) {
                    String name2 = type.getClassName();
                    int index = name2.lastIndexOf(46);
                    if (index >= 0) {
                        name2 = name2.substring(index + 1);
                    }
                    AnnotationScannerAction.this.tip.contains(name2);
                }
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
            return null;
        }

        @Override
        public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value) {
            return null;
        }
    }
}

