/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.oc4j;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

class OC4JClassPreprocessorAdapter
implements InvocationHandler {
    private final ClassFileTransformer transformer;

    public OC4JClassPreprocessorAdapter(ClassFileTransformer transformer) {
        this.transformer = transformer;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name2 = method.getName();
        if ("equals".equals(name2)) {
            return proxy == args[0];
        }
        if ("hashCode".equals(name2)) {
            return this.hashCode();
        }
        if ("toString".equals(name2)) {
            return this.toString();
        }
        if ("initialize".equals(name2)) {
            this.initialize(proxy, (ClassLoader)args[0]);
            return null;
        }
        if ("processClass".equals(name2)) {
            return this.processClass((String)args[0], (byte[])args[1], (Integer)args[2], (Integer)args[3], (ProtectionDomain)args[4], (ClassLoader)args[5]);
        }
        throw new IllegalArgumentException("Unknown method: " + method);
    }

    public Object initialize(Object proxy, ClassLoader loader) {
        return proxy;
    }

    public byte[] processClass(String className, byte[] origClassBytes, int offset, int length, ProtectionDomain pd, ClassLoader loader) {
        try {
            byte[] tempArray = new byte[length];
            System.arraycopy(origClassBytes, offset, tempArray, 0, length);
            byte[] result = this.transformer.transform(loader, className.replace('.', '/'), null, pd, tempArray);
            return result != null ? result : origClassBytes;
        }
        catch (IllegalClassFormatException ex) {
            throw new IllegalStateException("Cannot transform because of illegal class format", ex);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append(" for transformer: ");
        builder.append(this.transformer);
        return builder.toString();
    }
}

