/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

public class HostEntryComparator {
    private static final int MAX_NET_MASK = 128;

    public static int compare(String s1, String s2) {
        if (HostEntryComparator.isFullName(s1) && HostEntryComparator.isFullName(s2)) {
            return HostEntryComparator.netmaskCmp(s1, s2);
        }
        if (HostEntryComparator.isFullName(s1)) {
            return -1;
        }
        if (HostEntryComparator.isFullName(s2)) {
            return 1;
        }
        return HostEntryComparator.maskCmp(s1, s2);
    }

    private static int netmaskCmp(String s1, String s2) {
        return HostEntryComparator.compare(HostEntryComparator.netmaskOf(s1), HostEntryComparator.netmaskOf(s2));
    }

    private static int netmaskOf(String s) {
        int i = s.indexOf(47);
        return i > 0 ? Integer.parseInt(s.substring(i + 1)) : 128;
    }

    private static boolean isFullName(String s) {
        return s.indexOf(63) < 0 & s.indexOf(42) < 0;
    }

    private static int maskCmp(String s1, String s2) {
        int maskIndex1 = s1.indexOf(42);
        int maskIndex2 = s2.indexOf(42);
        return HostEntryComparator.compare(maskIndex2, maskIndex1);
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }
}

