/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.dcache.nfs.v4.StateDisposeListener;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.utils.Bytes;

public class NFS4State {
    private final stateid4 _stateid;
    private boolean _isConfimed = false;
    private boolean _disposed = false;
    private final List<StateDisposeListener> _disposeListeners;
    private static final SecureRandom RANDOM = new SecureRandom();

    public NFS4State(stateid4 stateid) {
        this._stateid = stateid;
        this._disposeListeners = new ArrayList<StateDisposeListener>();
    }

    public NFS4State(long clientid, int seqid) {
        this(new stateid4(NFS4State.generateState(clientid), seqid));
    }

    private static byte[] generateState(long clientid) {
        byte[] other = new byte[12];
        Bytes.putLong(other, 0, clientid);
        Bytes.putInt(other, 8, RANDOM.nextInt());
        return other;
    }

    public void bumpSeqid() {
        ++this._stateid.seqid.value;
    }

    public stateid4 stateid() {
        return this._stateid;
    }

    public void confirm() {
        this._isConfimed = true;
    }

    public boolean isConfimed() {
        return this._isConfimed;
    }

    public final synchronized void tryDispose() {
        if (!this._disposed) {
            this.dispose();
            for (StateDisposeListener disposeListener : this._disposeListeners) {
                disposeListener.notifyDisposed(this);
            }
            this._disposed = true;
        }
    }

    protected void dispose() {
    }

    public synchronized void addDisposeListener(StateDisposeListener disposeListener) {
        this._disposeListeners.add(disposeListener);
    }
}

