/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NFSv41Session;
import org.dcache.nfs.v4.xdr.sessionid4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.dcache.utils.Bytes;
import org.dcache.utils.Cache;
import org.dcache.utils.NopCacheEventListener;
import org.dcache.utils.Opaque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFSv4StateHandler {
    private static final Logger _log = LoggerFactory.getLogger(NFSv4StateHandler.class);
    private final List<NFS4Client> _clients = new ArrayList<NFS4Client>();
    private final Map<verifier4, NFS4Client> _clientsByVerifier = new HashMap<verifier4, NFS4Client>();
    private final Map<Long, NFS4Client> _clientsByServerId = new HashMap<Long, NFS4Client>();
    private final Cache<sessionid4, NFSv41Session> _sessionById = new Cache<sessionid4, NFSv41Session>("NFSv41 sessions", 5000, Long.MAX_VALUE, TimeUnit.SECONDS.toMillis(180L), new DeadSessionCollector(), 360L, TimeUnit.SECONDS);
    private final Map<Opaque, NFS4Client> _clientByOwner = new HashMap<Opaque, NFS4Client>();
    private final long _leaseTime;
    private final long _bootTime;

    public NFSv4StateHandler() {
        this(90000L);
    }

    NFSv4StateHandler(long leaseTime) {
        this._leaseTime = leaseTime;
        this._bootTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(NFS4Client client) {
        NFSv4StateHandler nFSv4StateHandler = this;
        synchronized (nFSv4StateHandler) {
            for (NFSv41Session session : client.sessions()) {
                this._sessionById.remove(session.id());
            }
            this._clientsByServerId.remove(client.getId());
            this._clientByOwner.remove(client.getOwner());
            this._clientsByVerifier.remove(client.verifier());
            this._clients.remove(client);
        }
        client.tryDispose();
    }

    private synchronized void addClient(NFS4Client newClient) {
        this._clients.add(newClient);
        this._clientsByServerId.put(newClient.getId(), newClient);
        this._clientsByVerifier.put(newClient.verifier(), newClient);
        this._clientByOwner.put(newClient.getOwner(), newClient);
    }

    public synchronized NFS4Client getClientByID(Long id) throws ChimeraNFSException {
        NFS4Client client = this._clientsByServerId.get(id);
        if (client == null) {
            throw new ChimeraNFSException(10022, "bad client id.");
        }
        return client;
    }

    public NFS4Client getClientIdByStateId(stateid4 stateId) throws ChimeraNFSException {
        return this.getClientByID(Bytes.getLong(stateId.other, 0));
    }

    public synchronized NFS4Client getClientByVerifier(verifier4 verifier) {
        return this._clientsByVerifier.get(verifier);
    }

    public synchronized NFSv41Session sessionById(sessionid4 id) {
        return this._sessionById.get(id);
    }

    public synchronized NFSv41Session removeSessionById(sessionid4 id) throws ChimeraNFSException {
        NFSv41Session session = this._sessionById.remove(id);
        if (session == null) {
            throw new ChimeraNFSException(10052, "session not found");
        }
        this.detachSession(session);
        return session;
    }

    public synchronized void sessionById(sessionid4 id, NFSv41Session session) {
        this._sessionById.put(id, session);
    }

    public synchronized NFS4Client clientByOwner(byte[] ownerid) {
        return this._clientByOwner.get(new Opaque(ownerid));
    }

    public void updateClientLeaseTime(stateid4 stateid) throws ChimeraNFSException {
        NFS4Client client = this.getClientIdByStateId(stateid);
        NFS4State state = client.state(stateid);
        if (!state.isConfimed()) {
            throw new ChimeraNFSException(10025, "State is not confirmed");
        }
        client.updateLeaseTime();
    }

    public synchronized List<NFS4Client> getClients() {
        return new CopyOnWriteArrayList<NFS4Client>(this._clients);
    }

    public NFS4Client createClient(InetSocketAddress clientAddress, InetSocketAddress localAddress, byte[] ownerID, verifier4 verifier, Principal principal) {
        NFS4Client client = new NFS4Client(clientAddress, localAddress, ownerID, verifier, principal, this._leaseTime);
        this.addClient(client);
        return client;
    }

    private void detachSession(NFSv41Session session) {
        NFS4Client client = session.getClient();
        client.removeSession(session);
        if (!client.hasSessions()) {
            this.removeClient(client);
        }
    }

    public boolean hasGracePeriodExpired() {
        return this._bootTime + TimeUnit.SECONDS.toMillis(90L) < System.currentTimeMillis();
    }

    private class DeadSessionCollector
    extends NopCacheEventListener<sessionid4, NFSv41Session> {
        private DeadSessionCollector() {
        }

        @Override
        public void notifyExpired(Cache<sessionid4, NFSv41Session> cache, NFSv41Session session) {
            _log.info("Removing expired session: {}", (Object)session);
            NFSv4StateHandler.this.detachSession(session);
        }
    }
}

