/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.client;

import java.io.IOException;
import java.util.ArrayList;
import org.dcache.nfs.v4.xdr.CREATE4args;
import org.dcache.nfs.v4.xdr.attrlist4;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.component4;
import org.dcache.nfs.v4.xdr.createtype4;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.fattr4_mode;
import org.dcache.nfs.v4.xdr.mode4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.utf8str_cs;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrBuffer;
import org.glassfish.grizzly.Buffer;

public class MkdirStub {
    public static nfs_argop4 generateRequest(String path) {
        CREATE4args args = new CREATE4args();
        args.objname = new component4(new utf8str_cs(path));
        args.objtype = new createtype4();
        args.objtype.type = 2;
        args.createattrs = new fattr4();
        args.createattrs.attr_vals = new attrlist4();
        args.createattrs.attr_vals.value = MkdirStub.openAttrs();
        args.createattrs.attrmask = MkdirStub.openFattrBitmap();
        nfs_argop4 op = new nfs_argop4();
        op.argop = 6;
        op.opcreate = args;
        return op;
    }

    private static bitmap4 openFattrBitmap() {
        ArrayList<Integer> attrs = new ArrayList<Integer>();
        attrs.add(33);
        bitmap4 afttrBitmap = new bitmap4();
        afttrBitmap.value = new uint32_t[2];
        afttrBitmap.value[0] = new uint32_t();
        afttrBitmap.value[1] = new uint32_t();
        for (Integer mask : attrs) {
            uint32_t bitmap;
            int bit;
            if (mask > 31) {
                bit = mask - 32;
                bitmap = afttrBitmap.value[1];
            } else {
                bit = mask;
                bitmap = afttrBitmap.value[0];
            }
            bitmap.value |= 1 << bit;
        }
        return afttrBitmap;
    }

    private static byte[] openAttrs() {
        XdrBuffer xdr = new XdrBuffer(1024);
        try {
            xdr.beginEncoding();
            mode4 fmode = new mode4();
            fmode.value = new uint32_t(493);
            fattr4_mode mode = new fattr4_mode(fmode);
            mode.xdrEncode(xdr);
        }
        catch (IOException | OncRpcException never_happens) {
            // empty catch block
        }
        xdr.endEncoding();
        Buffer b = xdr.asBuffer();
        byte[] retBytes = new byte[b.remaining()];
        b.get(retBytes);
        return retBytes;
    }
}

