/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

public class UnixPermission {
    private final int _mode;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    public static final int S_PERMS = 4095;
    public static final int s_ISTICKY = 512;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_TYPE = 258048;
    public static final int F_TYPE = 61440;

    public UnixPermission(int mode) {
        this._mode = mode;
    }

    public String toString() {
        char[] modeString = new char[]{'-', '-', '-', '-', '-', '-', '-', '-', '-', '-'};
        switch (UnixPermission.getType(this._mode)) {
            case 40960: {
                modeString[0] = 108;
                break;
            }
            case 32768: {
                break;
            }
            case 24576: {
                modeString[0] = 98;
                break;
            }
            case 16384: {
                modeString[0] = 100;
                break;
            }
            case 8192: {
                modeString[0] = 99;
                break;
            }
            case 4096: {
                modeString[0] = 70;
                break;
            }
            case 49152: {
                modeString[0] = 115;
                break;
            }
            default: {
                modeString[0] = 63;
            }
        }
        if ((this._mode & 0x100) == 256) {
            modeString[1] = 114;
        }
        if ((this._mode & 0x80) == 128) {
            modeString[2] = 119;
        }
        if ((this._mode & 0x40) == 64) {
            modeString[3] = (this._mode & 0x800) == 2048 ? 115 : 120;
        } else if ((this._mode & 0x800) == 2048) {
            modeString[3] = 83;
        }
        if ((this._mode & 0x20) == 32) {
            modeString[4] = 114;
        }
        if ((this._mode & 0x10) == 16) {
            modeString[5] = 119;
        }
        if ((this._mode & 8) == 8) {
            modeString[6] = (this._mode & 0x400) == 1024 ? 115 : 120;
        } else if ((this._mode & 0x400) == 1024) {
            modeString[6] = 83;
        }
        if ((this._mode & 4) == 4) {
            modeString[7] = 114;
        }
        if ((this._mode & 2) == 2) {
            modeString[8] = 119;
        }
        if ((this._mode & 1) == 1) {
            modeString[9] = 120;
        }
        return String.valueOf(modeString);
    }

    public boolean isSymLink() {
        return UnixPermission.getType(this._mode) == 40960;
    }

    public boolean isCharDev() {
        return UnixPermission.getType(this._mode) == 8192;
    }

    public boolean isBlockDev() {
        return UnixPermission.getType(this._mode) == 24576;
    }

    public boolean isDir() {
        return UnixPermission.getType(this._mode) == 16384;
    }

    public boolean isReg() {
        return UnixPermission.getType(this._mode) == 32768;
    }

    public static int getType(int mode) {
        return mode & 0xF000;
    }
}

