/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.client.cmd;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Args
implements Serializable {
    private static final long serialVersionUID = 4389995682226525641L;
    private final ImmutableListMultimap<String, String> _options;
    private final String _oneChar;
    private ImmutableList<String> _arguments;

    public Args(CharSequence args) {
        Scanner scanner = new Scanner(args);
        scanner.scan();
        this._options = scanner.options.build();
        this._arguments = scanner.arguments.build();
        this._oneChar = scanner.oneChar.toString();
    }

    public Args(String[] args) {
        this(Joiner.on(' ').join(args));
    }

    public Args(Args in) {
        this._arguments = in._arguments;
        this._options = in._options;
        this._oneChar = in._oneChar;
    }

    public boolean isOneCharOption(char c) {
        return this._oneChar.indexOf(c) > -1;
    }

    public int argc() {
        return this._arguments.size();
    }

    public int optc() {
        return this._options.size();
    }

    public String getOpt(String name2) {
        return this.getOption(name2);
    }

    public double getDoubleOption(String name2) {
        String option = this.getOption(name2);
        if (option == null) {
            throw new NoSuchElementException("Argument " + name2 + " does not exist.");
        }
        return Double.parseDouble(option);
    }

    public double getDoubleOption(String name2, double defaultValue) {
        String option = this.getOption(name2);
        if (option == null) {
            return defaultValue;
        }
        if (option.isEmpty()) {
            throw new IllegalArgumentException("Argument " + name2 + " does not have a value.");
        }
        return Double.parseDouble(option);
    }

    public int getIntOption(String name2) {
        String option = this.getOption(name2);
        if (option == null) {
            throw new NoSuchElementException("Argument " + name2 + " does not exist.");
        }
        return Integer.parseInt(option);
    }

    public int getIntOption(String name2, int defaultValue) {
        String option = this.getOption(name2);
        if (option == null) {
            return defaultValue;
        }
        if (option.isEmpty()) {
            throw new IllegalArgumentException("Argument " + name2 + " does not have a value.");
        }
        return Integer.parseInt(option);
    }

    public long getLongOption(String name2) {
        String option = this.getOption(name2);
        if (option == null) {
            throw new NoSuchElementException("Argument " + name2 + " does not exist.");
        }
        return Long.parseLong(option);
    }

    public long getLongOption(String name2, long defaultValue) {
        String option = this.getOption(name2);
        if (option == null) {
            return defaultValue;
        }
        if (option.isEmpty()) {
            throw new IllegalArgumentException("Argument " + name2 + " does not have a value.");
        }
        return Long.parseLong(option);
    }

    public String getOption(String name2) {
        ImmutableCollection values = this._options.get((Object)name2);
        return values.isEmpty() ? null : (String)values.get(values.size() - 1);
    }

    public boolean hasOption(String name2) {
        return !this._options.get((Object)name2).isEmpty();
    }

    public ImmutableList<String> getOptions(String name2) {
        return this._options.get((Object)name2);
    }

    public String argv(int i) {
        return i < this._arguments.size() ? (String)this._arguments.get(i) : null;
    }

    public ImmutableList<String> getArguments() {
        return this._arguments;
    }

    public String optv(int i) {
        Multiset keys = this._options.keys();
        return i < keys.size() ? (String)((ImmutableCollection)((Object)keys)).asList().get(i) : null;
    }

    public void shift() {
        if (!this._arguments.isEmpty()) {
            this._arguments = this._arguments.subList(1, this._arguments.size());
        }
    }

    public ImmutableListMultimap<String, String> options() {
        return this._options;
    }

    public ImmutableMap<String, String> optionsAsMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : this._options.entries()) {
            builder.put(e.getKey(), e.getValue());
        }
        return builder.build();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Args)) {
            return false;
        }
        Args args = (Args)other;
        return args._options.equals(this._options) && args._arguments.equals(this._arguments) && args._oneChar.equals(this._oneChar);
    }

    public int hashCode() {
        return Objects.hashCode(this._options, this._arguments);
    }

    private void quote(String in, StringBuilder out) {
        block7: for (int i = 0; i < in.length(); ++i) {
            switch (in.charAt(i)) {
                case '\\': {
                    out.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    out.append("\\'");
                    continue block7;
                }
                case '=': {
                    out.append("\\=");
                    continue block7;
                }
                case ' ': {
                    out.append("\\ ");
                    continue block7;
                }
                default: {
                    out.append(in.charAt(i));
                }
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry e : this._options.entries()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            s.append('-');
            this.quote(key, s);
            if (value.length() > 0) {
                s.append('=');
                this.quote(value, s);
            }
            s.append(' ');
        }
        if (s.length() > 0) {
            s.append("-- ");
        }
        Joiner.on(' ').appendTo(s, (Iterable<?>)this._arguments);
        return s.toString();
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Positional :\n");
        for (int i = 0; i < this._arguments.size(); ++i) {
            sb.append(i).append(" -> ").append((String)this._arguments.get(i)).append("\n");
        }
        sb.append("Options :\n");
        for (Map.Entry option : this._options.entries()) {
            sb.append((String)option.getKey());
            if (option.getValue() != null) {
                sb.append(" -> ").append((String)option.getValue());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage : ... <parseString>");
            System.exit(4);
        }
        Args lineArgs = args.length == 1 ? new Args(args[0]) : new Args(args);
        System.out.print(lineArgs.getInfo());
        System.out.println("pvr=" + lineArgs.getOpt("pvr"));
    }

    private static class Scanner {
        ImmutableListMultimap.Builder<String, String> options;
        ImmutableList.Builder<String> arguments;
        StringBuilder oneChar;
        private final CharSequence _line;
        private int _position;

        public Scanner(CharSequence line) {
            this._line = line;
        }

        private char peek() {
            return this.isEof() ? (char)'\u0000' : this._line.charAt(this._position);
        }

        private char readChar() {
            char c = this.peek();
            ++this._position;
            return c;
        }

        private boolean isEof() {
            return this._position >= this._line.length();
        }

        private boolean isWhitespace() {
            return Character.isWhitespace(this.peek());
        }

        private void scanWhitespace() {
            while (this.isWhitespace()) {
                this.readChar();
            }
        }

        public void scan() {
            boolean isAtEndOfOptions = false;
            this.options = new ImmutableListMultimap.Builder();
            this.arguments = new ImmutableList.Builder();
            this.oneChar = new StringBuilder();
            this.scanWhitespace();
            while (!this.isEof()) {
                if (!isAtEndOfOptions && this.peek() == '-') {
                    this.readChar();
                    String key = this.scanKey();
                    if (key.isEmpty()) {
                        this.arguments.add((Object)"-");
                    } else if (this.peek() == '=') {
                        this.readChar();
                        this.options.put((Object)key, (Object)this.scanWord());
                    } else if (key.equals("-")) {
                        isAtEndOfOptions = true;
                    } else {
                        this.options.put((Object)key, (Object)"");
                        this.oneChar.append(key);
                    }
                } else {
                    this.arguments.add((Object)this.scanWord());
                }
                this.scanWhitespace();
            }
        }

        private String scanKey() {
            StringBuilder key = new StringBuilder();
            do {
                this.scanWordElement(key);
            } while (!this.isEof() && !this.isWhitespace() && this.peek() != '=');
            return key.toString();
        }

        private String scanWord() {
            StringBuilder word = new StringBuilder();
            while (!this.isEof() && !this.isWhitespace()) {
                this.scanWordElement(word);
            }
            return word.toString();
        }

        private void scanWordElement(StringBuilder word) {
            if (!this.isEof() && !this.isWhitespace()) {
                switch (this.peek()) {
                    case '\'': {
                        this.scanSingleQuotedString(word);
                        break;
                    }
                    case '\"': {
                        this.scanDoubleQuotedString(word);
                        break;
                    }
                    case '\\': {
                        this.scanEscapedCharacter(word);
                        break;
                    }
                    default: {
                        word.append(this.readChar());
                    }
                }
            }
        }

        private void scanSingleQuotedString(StringBuilder word) {
            if (this.readChar() != '\'') {
                throw new IllegalStateException("Parse failure");
            }
            while (!this.isEof()) {
                char c = this.readChar();
                switch (c) {
                    case '\'': {
                        return;
                    }
                }
                word.append(c);
            }
        }

        private void scanDoubleQuotedString(StringBuilder word) {
            if (this.readChar() != '\"') {
                throw new IllegalStateException("Parse failure");
            }
            block4: while (!this.isEof()) {
                switch (this.peek()) {
                    case '\\': {
                        this.scanEscapedCharacter(word);
                        continue block4;
                    }
                    case '\"': {
                        this.readChar();
                        return;
                    }
                }
                word.append(this.readChar());
            }
        }

        private void scanEscapedCharacter(StringBuilder word) {
            if (this.readChar() != '\\') {
                throw new IllegalStateException("Parse failure");
            }
            if (!this.isEof()) {
                word.append(this.readChar());
            }
        }
    }
}

