/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.dcache.nfs.v4.StateDisposeListener;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.utils.Bytes;

public class NFS4State {
    private final stateid4 _stateid;
    private boolean _isConfimed = false;
    private boolean _disposed = false;
    private final uint32_t _openSeqid;
    private final List<StateDisposeListener> _disposeListeners;
    private static final SecureRandom RANDOM = new SecureRandom();

    public NFS4State(stateid4 stateid, uint32_t openSeqid) {
        this._stateid = stateid;
        this._disposeListeners = new ArrayList<StateDisposeListener>();
        this._openSeqid = openSeqid;
    }

    public NFS4State(long clientid, int seqid, uint32_t openSeqid) {
        this(new stateid4(NFS4State.generateState(clientid), seqid), openSeqid);
    }

    private static byte[] generateState(long clientid) {
        byte[] other = new byte[12];
        Bytes.putLong(other, 0, clientid);
        Bytes.putInt(other, 8, RANDOM.nextInt());
        return other;
    }

    public void bumpSeqid() {
        ++this._stateid.seqid.value;
    }

    public stateid4 stateid() {
        return this._stateid;
    }

    public void confirm() {
        this._isConfimed = true;
    }

    public boolean isConfimed() {
        return this._isConfimed;
    }

    public uint32_t getOpenSeqid() {
        return this._openSeqid;
    }

    public final synchronized void tryDispose() {
        if (!this._disposed) {
            this.dispose();
            for (StateDisposeListener disposeListener : this._disposeListeners) {
                disposeListener.notifyDisposed(this);
            }
            this._disposed = true;
        }
    }

    protected void dispose() {
    }

    public synchronized void addDisposeListener(StateDisposeListener disposeListener) {
        this._disposeListeners.add(disposeListener);
    }
}

