/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.Arrays;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.OperationGETATTR;
import org.dcache.nfs.v4.xdr.VERIFY4res;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.xdr.OncRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationVERIFY
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationVERIFY.class);

    OperationVERIFY(nfs_argop4 args) {
        super(args, 37);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        VERIFY4res res = result.opverify;
        res.status = 0;
        if (!this._args.opverify.obj_attributes.attrmask.isEmpty()) {
            fattr4 currentAttr = OperationGETATTR.getAttributes(this._args.opverify.obj_attributes.attrmask, context.getFs(), context.currentInode(), context);
            if (!Arrays.equals(this._args.opverify.obj_attributes.attrmask.value, currentAttr.attrmask.value)) {
                throw new ChimeraNFSException(10032, "check for not supported attribute");
            }
            if (this._args.opverify.obj_attributes.attrmask.isSet(11)) {
                throw new ChimeraNFSException(22, "RDATTR_ERROR can be used with readdir only");
            }
            res.status = Arrays.equals(this._args.opverify.obj_attributes.attr_vals.value, currentAttr.attr_vals.value) ? 0 : 10027;
        }
        _log.debug("{} is same? {}", (Object)context.currentInode(), (Object)res.status);
    }
}

