/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.xdr;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrDecodingStream;
import org.dcache.xdr.XdrEncodingStream;

public class nfstime4
implements XdrAble {
    private static final int MAX_VALID_NSECONDS = 999999999;
    public long seconds;
    public int nseconds;

    public nfstime4() {
    }

    public nfstime4(long millis) {
        this.seconds = millis / 1000L;
        this.nseconds = (int)(millis % 1000L * 1000000L);
    }

    public nfstime4(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.xdrDecode(xdr);
    }

    @Override
    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        xdr.xdrEncodeLong(this.seconds);
        xdr.xdrEncodeInt(this.nseconds);
    }

    @Override
    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.seconds = xdr.xdrDecodeLong();
        this.nseconds = xdr.xdrDecodeInt();
    }

    public long toMillis() throws ChimeraNFSException {
        if (this.nseconds < 0 || this.nseconds > 999999999) {
            throw new ChimeraNFSException(22, "Invalid value for nseconds");
        }
        return TimeUnit.MILLISECONDS.convert(this.seconds, TimeUnit.SECONDS) + TimeUnit.MILLISECONDS.convert(this.nseconds, TimeUnit.NANOSECONDS);
    }
}

