/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.pfl.tf.timer.impl.ControllableBase;
import org.glassfish.pfl.tf.timer.impl.LogEventHandlerImpl;
import org.glassfish.pfl.tf.timer.impl.MultiThreadedStatsEventHandlerImpl;
import org.glassfish.pfl.tf.timer.impl.StatsEventHandlerImpl;
import org.glassfish.pfl.tf.timer.impl.TimerGroupImpl;
import org.glassfish.pfl.tf.timer.impl.TimerImpl;
import org.glassfish.pfl.tf.timer.spi.Controllable;
import org.glassfish.pfl.tf.timer.spi.LogEventHandler;
import org.glassfish.pfl.tf.timer.spi.NamedBase;
import org.glassfish.pfl.tf.timer.spi.ObjectRegistrationManager;
import org.glassfish.pfl.tf.timer.spi.StatsEventHandler;
import org.glassfish.pfl.tf.timer.spi.Timer;
import org.glassfish.pfl.tf.timer.spi.TimerEvent;
import org.glassfish.pfl.tf.timer.spi.TimerEventController;
import org.glassfish.pfl.tf.timer.spi.TimerEventControllerBase;
import org.glassfish.pfl.tf.timer.spi.TimerEventHandler;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;
import org.glassfish.pfl.tf.timer.spi.TimerGroup;

public class TimerFactoryImpl
extends TimerGroupImpl
implements TimerFactory {
    private ObjectRegistrationManager orm;
    private Map<Controllable, Integer> conToInt;
    private Map<Integer, Controllable> intToCon;
    private int nextIndex;
    private Map<String, TimerImpl> timers;
    private Map<String, TimerImpl> roTimers;
    private Map<String, TimerGroupImpl> timerGroups;
    private Map<String, TimerGroupImpl> roTimerGroups;
    private Map<String, TimerEventHandler> timerEventHandlers;
    private Map<String, TimerEventControllerBase> timerEventControllers;

    public TimerFactoryImpl(ObjectRegistrationManager orm, String name2, String description) {
        super(0, null, name2, description);
        this.orm = orm;
        this.setFactory(this);
        this.add(this);
        this.conToInt = new HashMap<Controllable, Integer>();
        this.intToCon = new HashMap<Integer, Controllable>();
        this.nextIndex = 0;
        this.mapId(this);
        this.timers = new LinkedHashMap<String, TimerImpl>();
        this.roTimers = Collections.unmodifiableMap(this.timers);
        this.timerGroups = new LinkedHashMap<String, TimerGroupImpl>();
        this.timerGroups.put(this.name(), this);
        this.roTimerGroups = Collections.unmodifiableMap(this.timerGroups);
        this.timerEventHandlers = new HashMap<String, TimerEventHandler>();
        this.timerEventControllers = new HashMap<String, TimerEventControllerBase>();
        orm.manage(this);
    }

    private void mapId(Controllable con) {
        this.conToInt.put(con, con.id());
        this.intToCon.put(con.id(), con);
        ++this.nextIndex;
    }

    private void checkArgs(Set<String> inUse, String name2, String description) {
        if (name2 == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description must not be null");
        }
        if (inUse.contains(name2)) {
            throw new IllegalArgumentException(name2 + " is already used.");
        }
    }

    @Override
    public synchronized int numberOfIds() {
        return this.nextIndex;
    }

    @Override
    public synchronized Controllable getControllable(int id) {
        if (id >= 0 && id < this.nextIndex) {
            return this.intToCon.get(id);
        }
        throw new IllegalArgumentException("Argument " + id + " must be between 0 and " + (this.nextIndex - 1));
    }

    @Override
    public synchronized TimerEventHandler makeTracingEventHandler(String name2) {
        if (this.timerEventHandlers.keySet().contains(name2)) {
            throw new IllegalArgumentException("Name " + name2 + " is already in use.");
        }
        TracingEventHandler result = new TracingEventHandler(this.factory(), name2);
        this.orm.manage(this, result);
        this.timerEventHandlers.put(name2, result);
        return result;
    }

    @Override
    public synchronized LogEventHandler makeLogEventHandler(String name2) {
        if (this.timerEventHandlers.keySet().contains(name2)) {
            throw new IllegalArgumentException("Name " + name2 + " is already in use.");
        }
        LogEventHandlerImpl result = new LogEventHandlerImpl(this.factory(), name2);
        this.orm.manage(this, result);
        this.timerEventHandlers.put(name2, result);
        return result;
    }

    @Override
    public synchronized StatsEventHandler makeStatsEventHandler(String name2) {
        if (this.timerEventHandlers.keySet().contains(name2)) {
            throw new IllegalArgumentException("Name " + name2 + " is already in use.");
        }
        StatsEventHandlerImpl result = new StatsEventHandlerImpl(this.factory(), name2);
        this.orm.manage(this, result);
        this.timerEventHandlers.put(name2, result);
        return result;
    }

    @Override
    public synchronized StatsEventHandler makeMultiThreadedStatsEventHandler(String name2) {
        if (this.timerEventHandlers.keySet().contains(name2)) {
            throw new IllegalArgumentException("Name " + name2 + " is already in use.");
        }
        MultiThreadedStatsEventHandlerImpl result = new MultiThreadedStatsEventHandlerImpl(this.factory(), name2);
        this.orm.manage(this, result);
        this.timerEventHandlers.put(name2, result);
        return result;
    }

    @Override
    public synchronized void removeTimerEventHandler(TimerEventHandler handler) {
        this.timerEventHandlers.remove(handler.name());
        this.orm.unmanage(handler);
    }

    @Override
    public synchronized Timer makeTimer(String name2, String description) {
        this.checkArgs(this.timers.keySet(), name2, description);
        TimerImpl result = new TimerImpl(this.nextIndex, this, name2, description);
        this.orm.manage(this, result);
        this.mapId(result);
        this.timers.put(name2, result);
        this.add(result);
        return result;
    }

    public synchronized Map<String, TimerImpl> timers() {
        return this.roTimers;
    }

    @Override
    public synchronized TimerGroup makeTimerGroup(String name2, String description) {
        this.checkArgs(this.timerGroups.keySet(), name2, description);
        TimerGroupImpl result = new TimerGroupImpl(this.nextIndex, this, name2, description);
        this.orm.manage(this, result);
        this.mapId(result);
        this.timerGroups.put(result.name(), result);
        this.add(result);
        return result;
    }

    public synchronized Map<String, TimerGroupImpl> timerGroups() {
        return this.roTimerGroups;
    }

    public void saveTimerEventController(TimerEventControllerBase tec) {
        if (this.timerEventControllers.keySet().contains(tec.name())) {
            throw new IllegalArgumentException("Name " + tec.name() + " is already in use.");
        }
        this.timerEventControllers.put(tec.name(), tec);
    }

    @Override
    public synchronized TimerEventController makeController(String name2) {
        TimerEventController result = new TimerEventController(this, name2);
        this.orm.manage(this, result);
        return result;
    }

    @Override
    public synchronized void removeController(TimerEventControllerBase controller) {
        this.timerEventControllers.remove(controller.name());
        this.orm.unmanage(controller);
    }

    @Override
    public synchronized Set<? extends Controllable> enabledSet() {
        HashSet<ControllableBase> result = new HashSet<ControllableBase>();
        for (TimerImpl t : this.timers.values()) {
            if (!t.isEnabled()) continue;
            result.add(t);
        }
        for (TimerGroupImpl tg : this.timerGroups.values()) {
            if (!tg.isEnabled()) continue;
            result.add(tg);
        }
        return result;
    }

    @Override
    public synchronized Set<Timer> activeSet() {
        HashSet<Timer> result = new HashSet<Timer>();
        for (TimerImpl t : this.timers.values()) {
            if (!t.isActivated()) continue;
            result.add(t);
        }
        return result;
    }

    void updateActivation() {
        for (TimerImpl timer : this.timers.values()) {
            timer.setActivated(timer.isEnabled());
        }
        for (TimerGroupImpl tg : this.timerGroups.values()) {
            if (!tg.isEnabled()) continue;
            Set<ControllableBase> tcc = tg.tcContents();
            for (ControllableBase c : tcc) {
                if (!(c instanceof Timer)) continue;
                TimerImpl ti = (TimerImpl)TimerImpl.class.cast(c);
                ti.setActivated(true);
            }
        }
    }

    @Override
    public synchronized boolean timerAlreadyExists(String name2) {
        return this.timers.keySet().contains(name2);
    }

    public static class TracingEventHandler
    extends NamedBase
    implements TimerEventHandler {
        public TracingEventHandler(TimerFactory factory, String name2) {
            super(factory, name2);
        }

        @Override
        public void notify(TimerEvent event) {
            System.out.println(Thread.currentThread().getName() + " TRACE " + event);
        }
    }
}

