/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl;

import java.io.Serializable;
import org.dcache.acl.enums.AccessMask;
import org.dcache.acl.enums.AceType;
import org.dcache.acl.enums.Who;

public class ACE
implements Serializable {
    static final long serialVersionUID = -7088617639500399472L;
    public static final String DEFAULT_ADDRESS_MSK = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private final AceType _type;
    private final int _flags;
    private final int _accessMsk;
    private final Who _who;
    private final int _whoID;
    private final String _addressMsk;

    public ACE(AceType type, int flags, int accessMsk, Who who, int whoID, String addressMsk) {
        this._type = type;
        this._flags = flags;
        this._accessMsk = accessMsk;
        this._who = who;
        this._whoID = whoID;
        this._addressMsk = addressMsk;
    }

    public int getAccessMsk() {
        return this._accessMsk;
    }

    public String getAddressMsk() {
        return this._addressMsk;
    }

    public boolean isDefaultAddressMsk(String addressMsk) {
        return DEFAULT_ADDRESS_MSK.equalsIgnoreCase(addressMsk);
    }

    public boolean isDefaultAddressMsk() {
        return this.isDefaultAddressMsk(this._addressMsk);
    }

    public int getFlags() {
        return this._flags;
    }

    public AceType getType() {
        return this._type;
    }

    public Who getWho() {
        return this._who;
    }

    public int getWhoID() {
        return this._whoID;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ACE other = (ACE)obj;
        if (this._type != other._type) {
            return false;
        }
        if (this._flags != other._flags) {
            return false;
        }
        if (this._accessMsk != other._accessMsk) {
            return false;
        }
        if (this._who != other._who) {
            return false;
        }
        if (this._whoID != other._whoID) {
            return false;
        }
        return this._addressMsk.equals(other._addressMsk);
    }

    public int hashCode() {
        return this._type.hashCode() ^ this._flags ^ this._accessMsk ^ this._who.hashCode() ^ this._whoID ^ this._addressMsk.hashCode();
    }

    public String toString() {
        return String.format("%s:%s:%d:%s", new Object[]{this._type.getAbbreviation(), this._who, this._whoID, AccessMask.asString(this._accessMsk)});
    }
}

