/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.LAYOUTCOMMIT4res;
import org.dcache.nfs.v4.xdr.LAYOUTCOMMIT4resok;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.newsize4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLAYOUTCOMMIT
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLAYOUTCOMMIT.class);

    OperationLAYOUTCOMMIT(nfs_argop4 args) {
        super(args, 49);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        Stat stat;
        long currentSize;
        long newSize;
        LAYOUTCOMMIT4res res = result.oplayoutcommit;
        _log.debug("LAYOUTCOMMIT: inode=" + context.currentInode() + " length=" + this._args.oplayoutcommit.loca_length.value + " offset=" + this._args.oplayoutcommit.loca_offset.value + " loca_last_write_offset=" + (this._args.oplayoutcommit.loca_last_write_offset.no_newoffset ? Long.valueOf(this._args.oplayoutcommit.loca_last_write_offset.no_offset.value) : "notset"));
        res.locr_resok4 = new LAYOUTCOMMIT4resok();
        res.locr_resok4.locr_newsize = new newsize4();
        res.locr_resok4.locr_newsize.ns_sizechanged = false;
        if (this._args.oplayoutcommit.loca_last_write_offset.no_newoffset && (newSize = this._args.oplayoutcommit.loca_last_write_offset.no_offset.value + 1L) > (currentSize = (stat = context.getFs().getattr(context.currentInode())).getSize())) {
            stat.setSize(newSize);
            context.getFs().setattr(context.currentInode(), stat);
            res.locr_resok4.locr_newsize.ns_sizechanged = true;
            res.locr_resok4.locr_newsize.ns_size = new length4(newSize);
        }
        res.locr_status = 0;
    }
}

