/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VfsCacheConfig;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.utils.Opaque;

public class VfsCache
implements VirtualFileSystem {
    private final Cache<CacheKey, Inode> _lookupCache;
    private final Cache<Opaque, Stat> _statCache;
    private final VirtualFileSystem _inner;

    public VfsCache(VirtualFileSystem inner, VfsCacheConfig cacheConfig) {
        this._inner = inner;
        this._lookupCache = CacheBuilder.newBuilder().maximumSize(cacheConfig.getMaxEntries()).expireAfterWrite(cacheConfig.getLifeTime(), cacheConfig.getTimeUnit()).softValues().build();
        this._statCache = CacheBuilder.newBuilder().maximumSize(cacheConfig.getMaxEntries()).expireAfterWrite(cacheConfig.getLifeTime(), cacheConfig.getTimeUnit()).softValues().build();
    }

    @Override
    public int write(Inode inode, byte[] data, long offset, int count) throws IOException {
        return this._inner.write(inode, data, offset, count);
    }

    @Override
    public Inode symlink(Inode parent, String path, String link, int uid, int gid, int mode) throws IOException {
        Inode inode = this._inner.symlink(parent, path, link, uid, gid, mode);
        this.invalidateStatCache(parent);
        return inode;
    }

    @Override
    public void remove(Inode parent, String path) throws IOException {
        Inode inode = this.lookup(parent, path);
        this._inner.remove(parent, path);
        this.invalidateLookupCache(parent, path);
        this.invalidateStatCache(parent);
        this.invalidateStatCache(inode);
    }

    @Override
    public String readlink(Inode inode) throws IOException {
        return this._inner.readlink(inode);
    }

    @Override
    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        return this._inner.read(inode, data, offset, count);
    }

    @Override
    public Inode parentOf(Inode inode) throws IOException {
        return this._inner.parentOf(inode);
    }

    @Override
    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        boolean isChanged = this._inner.move(src, oldName, dest, newName);
        if (isChanged) {
            this.invalidateLookupCache(src, oldName);
            this.invalidateLookupCache(dest, newName);
            this.invalidateStatCache(src);
            this.invalidateStatCache(dest);
        }
        return isChanged;
    }

    @Override
    public Inode mkdir(Inode parent, String path, int uid, int gid, int mode) throws IOException {
        Inode inode = this._inner.mkdir(parent, path, uid, gid, mode);
        this.updateLookupCache(parent, path, inode);
        this.invalidateStatCache(parent);
        return inode;
    }

    @Override
    public List<DirectoryEntry> list(Inode inode) throws IOException {
        return this._inner.list(inode);
    }

    @Override
    public Inode link(Inode parent, Inode link, String path, int uid, int gid) throws IOException {
        Inode inode = this._inner.link(parent, link, path, uid, gid);
        this.updateLookupCache(parent, path, inode);
        this.invalidateStatCache(parent);
        this.invalidateStatCache(inode);
        return inode;
    }

    @Override
    public Inode lookup(Inode parent, String path) throws IOException {
        return this.lookupFromCacheOrLoad(parent, path);
    }

    @Override
    public Inode getRootInode() throws IOException {
        return this._inner.getRootInode();
    }

    @Override
    public FsStat getFsStat() throws IOException {
        return this._inner.getFsStat();
    }

    @Override
    public Inode create(Inode parent, Stat.Type type, String path, int uid, int gid, int mode) throws IOException {
        Inode inode = this._inner.create(parent, type, path, uid, gid, mode);
        this.updateLookupCache(parent, path, inode);
        this.invalidateStatCache(parent);
        return inode;
    }

    @Override
    public int access(Inode inode, int mode) throws IOException {
        return this._inner.access(inode, mode);
    }

    @Override
    public Stat getattr(Inode inode) throws IOException {
        return this.statFromCacheOrLoad(inode);
    }

    @Override
    public void setattr(Inode inode, Stat stat) throws IOException {
        this._inner.setattr(inode, stat);
        this.invalidateStatCache(inode);
    }

    @Override
    public nfsace4[] getAcl(Inode inode) throws IOException {
        return this._inner.getAcl(inode);
    }

    @Override
    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
        this._inner.setAcl(inode, acl);
    }

    @Override
    public boolean hasIOLayout(Inode inode) throws IOException {
        return this._inner.hasIOLayout(inode);
    }

    @Override
    public AclCheckable getAclCheckable() {
        return this._inner.getAclCheckable();
    }

    private void invalidateLookupCache(Inode parent, String path) {
        this._lookupCache.invalidate(new CacheKey(parent, path));
    }

    private void updateLookupCache(Inode parent, String path, Inode inode) {
        this._lookupCache.put(new CacheKey(parent, path), inode);
    }

    private void invalidateStatCache(Inode inode) {
        this._statCache.invalidate(new Opaque(inode.getFileId()));
    }

    private Inode lookupFromCacheOrLoad(final Inode parent, final String path) throws IOException {
        try {
            return this._lookupCache.get(new CacheKey(parent, path), new Callable<Inode>(){

                @Override
                public Inode call() throws Exception {
                    return VfsCache.this._inner.lookup(parent, path);
                }
            });
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf(t, IOException.class);
            throw new IOException(e.getMessage(), t);
        }
    }

    private Stat statFromCacheOrLoad(final Inode inode) throws IOException {
        try {
            return this._statCache.get(new Opaque(inode.getFileId()), new Callable<Stat>(){

                @Override
                public Stat call() throws Exception {
                    return VfsCache.this._inner.getattr(inode);
                }
            });
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf(t, IOException.class);
            throw new IOException(e.getMessage(), t);
        }
    }

    private static class CacheKey {
        private final Inode _parent;
        private final String _name;

        public CacheKey(Inode parent, String name2) {
            this._parent = parent;
            this._name = name2;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return other._parent.equals(this._parent) & other._name.equals(this._name);
        }

        public int hashCode() {
            return this._name.hashCode() ^ this._parent.hashCode();
        }

        public String getName() {
            return this._name;
        }

        public Inode getParent() {
            return this._parent;
        }
    }
}

