/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.dcache.xdr.ClientTransport;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.RpcReply;
import org.dcache.xdr.Xdr;
import org.dcache.xdr.XdrTransport;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyXdrTransport
implements XdrTransport {
    private final FilterChainContext _context;
    private final Connection<InetSocketAddress> _connection;
    private final ReplyQueue<Integer, RpcReply> _replyQueue;
    private static final Logger _log = LoggerFactory.getLogger(GrizzlyXdrTransport.class);

    public GrizzlyXdrTransport(FilterChainContext context, ReplyQueue<Integer, RpcReply> replyQueue) {
        this._context = context;
        this._connection = context.getConnection();
        this._replyQueue = replyQueue;
    }

    public GrizzlyXdrTransport(FilterChainContext context) {
        this(context, null);
    }

    @Override
    public void send(Xdr xdr) throws IOException {
        final Buffer buffer = xdr.asBuffer();
        buffer.allowBufferDispose(true);
        this._context.write(this._context.getAddress(), buffer, (CompletionHandler<WriteResult>)new EmptyCompletionHandler<WriteResult>(){

            @Override
            public void failed(Throwable throwable) {
                _log.error("Failed to send RPC message: xid=0x{} remote={} : {}", Integer.toHexString(buffer.getInt(0)), GrizzlyXdrTransport.this._connection.getPeerAddress(), throwable.getMessage());
            }
        });
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this._context.getConnection().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this._context.getAddress();
    }

    @Override
    public ReplyQueue<Integer, RpcReply> getReplyQueue() {
        return this._replyQueue;
    }

    @Override
    public XdrTransport getPeerTransport() {
        return new ClientTransport(this._connection, this.getReplyQueue());
    }

    public String toString() {
        return this.getRemoteSocketAddress() + " <=> " + this.getLocalSocketAddress();
    }
}

