/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.IOHimeraFsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryStreamHelper {
    private static final Logger _log = LoggerFactory.getLogger(DirectoryStreamHelper.class);

    public static List<HimeraDirectoryEntry> listOf(FsInode inode) throws IOException, IOHimeraFsException {
        ArrayList<HimeraDirectoryEntry> directoryList;
        int estimatedListSize = inode.statCache().getNlink();
        if (estimatedListSize < 0) {
            _log.error("Invalid nlink count for directory {}", (Object)inode);
            directoryList = new ArrayList();
        } else {
            directoryList = new ArrayList<HimeraDirectoryEntry>(estimatedListSize);
        }
        try (DirectoryStreamB<HimeraDirectoryEntry> dirStream = inode.newDirectoryStream();){
            for (HimeraDirectoryEntry e : dirStream) {
                directoryList.add(e);
            }
        }
        return directoryList;
    }
}

