/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.layout4;
import org.dcache.nfs.v4.xdr.layout_content4;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.nfl_util4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.nfsv4_1_file_layout4;
import org.dcache.nfs.v4.xdr.offset4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.xdr.XdrBuffer;
import org.glassfish.grizzly.Buffer;

public class Layout {
    private final boolean _returnOnClose;
    private final stateid4 _stateid;
    private final layout4[] _layoutSegments;

    public Layout(boolean returnOnClose, stateid4 stateid, layout4[] layoutSegments) {
        this._returnOnClose = returnOnClose;
        this._stateid = stateid;
        this._layoutSegments = layoutSegments;
    }

    public boolean returnOnClose() {
        return this._returnOnClose;
    }

    public stateid4 getStateid() {
        return this._stateid;
    }

    public layout4[] getLayoutSegments() {
        return this._layoutSegments;
    }

    private static layout_content4 getSegmentContent(deviceid4 deviceid, nfs_fh4 fh) throws ChimeraNFSException {
        nfsv4_1_file_layout4 layout = new nfsv4_1_file_layout4();
        layout.nfl_deviceid = deviceid;
        layout.nfl_fh_list = new nfs_fh4[1];
        layout.nfl_fh_list[0] = fh;
        layout.nfl_first_stripe_index = new uint32_t(0);
        layout.nfl_util = new nfl_util4(new uint32_t(0x400000));
        layout.nfl_util = new nfl_util4(new uint32_t(layout.nfl_util.value.value));
        layout.nfl_pattern_offset = new offset4(0L);
        XdrBuffer xdr = new XdrBuffer(512);
        xdr.beginEncoding();
        try {
            layout.xdrEncode(xdr);
        }
        catch (IOException e) {
            throw new ChimeraNFSException(10006, "failed to encode layout body");
        }
        xdr.endEncoding();
        Buffer xdrBody = xdr.asBuffer();
        byte[] body = new byte[xdrBody.remaining()];
        xdrBody.get(body);
        layout_content4 content = new layout_content4();
        content.loc_type = 1;
        content.loc_body = body;
        return content;
    }

    public static layout4 getLayoutSegment(deviceid4 deviceid, nfs_fh4 fh, int iomode, long offset, long length) throws IOException {
        layout4 segment = new layout4();
        segment.lo_offset = new offset4(offset);
        segment.lo_length = new length4(length);
        segment.lo_iomode = iomode;
        segment.lo_content = new layout_content4();
        segment.lo_content = Layout.getSegmentContent(deviceid, fh);
        return segment;
    }
}

