/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.util.List;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.SessionSlot;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.sessionid4;
import org.dcache.utils.Bytes;

public class NFSv41Session {
    private final sessionid4 _session;
    private final SessionSlot[] _slots;
    private final NFS4Client _client;
    private final int _maxOps;
    private final int _maxCbOps;
    private final int _cbReplyCacheSize;
    private final int _sequence;

    public NFSv41Session(NFS4Client client, int sequence, int replyCacheSize, int cbReplyCacheSize, int maxOps, int maxCbOps) {
        this._client = client;
        this._sequence = sequence;
        this._slots = new SessionSlot[replyCacheSize];
        byte[] id = new byte[16];
        Bytes.putLong(id, 0, client.getId());
        Bytes.putInt(id, 12, sequence);
        this._session = new sessionid4(id);
        this._maxOps = maxOps;
        this._maxCbOps = maxCbOps;
        this._cbReplyCacheSize = cbReplyCacheSize;
    }

    public sessionid4 id() {
        return this._session;
    }

    public NFS4Client getClient() {
        return this._client;
    }

    public int getHighestSlot() {
        return this._slots.length - 1;
    }

    public int getCbHighestSlot() {
        return this._cbReplyCacheSize - 1;
    }

    public int getHighestUsedSlot() {
        int id;
        for (id = this.getHighestSlot(); id >= 0 && this._slots[id] == null; --id) {
        }
        return id;
    }

    public List<nfs_resop4> checkCacheSlot(int slot, int sequence, boolean checkCache) throws ChimeraNFSException {
        return this.getSlot(slot).checkSlotSequence(sequence, checkCache);
    }

    private SessionSlot getSlot(int slot) throws ChimeraNFSException {
        if (slot < 0 || slot > this.getHighestSlot()) {
            throw new ChimeraNFSException(10053, "slot id overflow");
        }
        if (this._slots[slot] == null) {
            this._slots[slot] = new SessionSlot();
        }
        return this._slots[slot];
    }

    public int getSequence() {
        return this._sequence;
    }

    public int getMaxOps() {
        return this._maxOps;
    }

    public int getMaxCbOps() {
        return this._maxCbOps;
    }

    public String toString() {
        return this._client.getRemoteAddress() + " : " + Bytes.toHexString(this._session.value);
    }

    public void updateSlotCache(int slot, List<nfs_resop4> reply) throws ChimeraNFSException {
        this.getSlot(slot).update(reply);
    }
}

