/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.GETDEVICEINFO4res;
import org.dcache.nfs.v4.xdr.GETDEVICEINFO4resok;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.device_addr4;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationGETDEVICEINFO
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationGETDEVICEINFO.class);

    OperationGETDEVICEINFO(nfs_argop4 args) {
        super(args, 47);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        GETDEVICEINFO4res res = result.opgetdeviceinfo;
        deviceid4 deviceId = this._args.opgetdeviceinfo.gdia_device_id;
        _log.debug("             Info for #{}", (Object)deviceId);
        _log.debug("             type for #{}", (Object)this._args.opgetdeviceinfo.gdia_layout_type);
        res.gdir_resok4 = new GETDEVICEINFO4resok();
        device_addr4 deviceInfo = context.getDeviceManager().getDeviceInfo(context, deviceId);
        if (deviceInfo == null) {
            throw new ChimeraNFSException(22, "invalid deviceInfo id");
        }
        res.gdir_resok4.gdir_device_addr = deviceInfo;
        res.gdir_resok4.gdir_device_addr.da_layout_type = 1;
        res.gdir_resok4.gdir_notification = new bitmap4();
        res.gdir_resok4.gdir_notification.value = new int[]{0};
        res.gdir_status = 0;
    }
}

