/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.Layout;
import org.dcache.nfs.v4.xdr.LAYOUTGET4res;
import org.dcache.nfs.v4.xdr.LAYOUTGET4resok;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLAYOUTGET
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLAYOUTGET.class);

    OperationLAYOUTGET(nfs_argop4 args) {
        super(args, 50);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        LAYOUTGET4res res = result.oplayoutget;
        length4 lengthRange = new length4(-1L);
        if (this._args.oplayoutget.loga_offset.value != 0L && this._args.oplayoutget.loga_length.value == 0L) {
            throw new ChimeraNFSException(22, "length == 0");
        }
        if (this._args.oplayoutget.loga_iomode != 2 && this._args.oplayoutget.loga_iomode != 1) {
            throw new ChimeraNFSException(10049, "invalid loga_iomode");
        }
        if (this._args.oplayoutget.loga_layout_type > 3) {
            throw new ChimeraNFSException(10050, "layouts supported but no matching found (" + this._args.oplayoutget.loga_layout_type + ")");
        }
        if (this._args.oplayoutget.loga_layout_type != 1) {
            throw new ChimeraNFSException(10059, "layout not supported");
        }
        res.logr_resok4 = new LAYOUTGET4resok();
        Layout ioLayout = context.getDeviceManager().layoutGet(context, context.currentInode(), this._args.oplayoutget.loga_iomode, this._args.oplayoutget.loga_stateid);
        res.logr_resok4.logr_layout = ioLayout.getLayoutSegments();
        res.logr_resok4.logr_stateid = ioLayout.getStateid();
        res.logr_resok4.logr_return_on_close = ioLayout.returnOnClose();
        res.logr_status = 0;
    }
}

